/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.iterator.AbstractIterator;

public class UniqueIterator<T>
extends AbstractIterator<Option<T>> {
    private final Iterator<Option<T>> iterator;
    private final TreeProvider<T> treeProvider;
    private T lastElement;

    public UniqueIterator(Iterator<Option<T>> input, TreeProvider<T> treeProvider) {
        this.iterator = input;
        this.treeProvider = treeProvider;
    }

    @Override
    protected Option<T> getElement() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        Option<T> candidate = this.iterator.next();
        Option<T> result = this.treeProvider.sameElement(this.lastElement, candidate.getElement()) ? Option.empty(candidate.getArgumentId()) : candidate;
        this.lastElement = candidate.getElement();
        return result;
    }
}

