/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.resource.jcr.query;

import java.util.Iterator;
import java.util.List;
import org.apache.sling.query.resource.jcr.query.Term;

public class Formula
implements Term {
    private final Operator operator;
    private final List<Term> conditions;

    public Formula(Operator operator, List<Term> conditions) {
        this.operator = operator;
        this.conditions = conditions;
    }

    @Override
    public String buildString() {
        if (this.conditions.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Term> iterator = this.conditions.iterator();
        if (this.conditions.size() > 1) {
            builder.append("(");
        }
        while (iterator.hasNext()) {
            Term term = iterator.next();
            builder.append(term.buildString());
            if (!iterator.hasNext()) continue;
            builder.append(' ').append(this.operator.toString()).append(' ');
        }
        if (this.conditions.size() > 1) {
            builder.append(")");
        }
        return builder.toString();
    }

    public static enum Operator {
        AND,
        OR;

    }
}

