/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.selector;

import org.apache.sling.query.api.Function;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.function.EvenFunction;
import org.apache.sling.query.function.FilterFunction;
import org.apache.sling.query.function.HasFunction;
import org.apache.sling.query.function.LastFunction;
import org.apache.sling.query.function.NotFunction;
import org.apache.sling.query.function.SliceFunction;
import org.apache.sling.query.predicate.ParentPredicate;
import org.apache.sling.query.predicate.RejectingPredicate;
import org.apache.sling.query.selector.SelectorFunction;

public enum FunctionType {
    EQ{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> providerw) {
            int index = Integer.parseInt(argument);
            return new SliceFunction(index, index);
        }
    }
    ,
    FIRST{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new SliceFunction(0, 0);
        }
    }
    ,
    LAST{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new LastFunction();
        }
    }
    ,
    GT{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new SliceFunction(Integer.valueOf(argument) + 1);
        }
    }
    ,
    LT{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new SliceFunction(0, Integer.valueOf(argument) - 1);
        }
    }
    ,
    HAS{

        @Override
        public <T> Function<?, ?> getFunction(String selector, SearchStrategy strategy, TreeProvider<T> provider) {
            return new HasFunction<T>(selector, strategy, provider);
        }
    }
    ,
    PARENT{

        @Override
        public <T> Function<?, ?> getFunction(String selector, SearchStrategy strategy, TreeProvider<T> provider) {
            return new FilterFunction<T>(new ParentPredicate<T>(provider));
        }
    }
    ,
    EMPTY{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new FilterFunction<T>(new RejectingPredicate<T>(new ParentPredicate<T>(provider)));
        }
    }
    ,
    ODD{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new EvenFunction(false);
        }
    }
    ,
    EVEN{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new EvenFunction(true);
        }
    }
    ,
    NOT{

        @Override
        public <T> Function<?, ?> getFunction(String argument, SearchStrategy strategy, TreeProvider<T> provider) {
            return new NotFunction<T>(new SelectorFunction<T>(argument, provider, strategy));
        }
    };


    public abstract <T> Function<?, ?> getFunction(String var1, SearchStrategy var2, TreeProvider<T> var3);
}

