/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import java.util.List;
import org.apache.sling.query.api.internal.IteratorToIteratorFunction;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.AbstractIterator;
import org.apache.sling.query.iterator.ArgumentResettingIterator;

public class SuppIterator<T>
extends AbstractIterator<Option<T>> {
    private final List<Option<T>> input;
    private final Iterator<Option<T>> output;
    private Option<T> outputElement;
    private int currentIndex = 0;

    public SuppIterator(List<Option<T>> input, IteratorToIteratorFunction<T> function) {
        this.input = input;
        this.output = (Iterator)function.apply(new ArgumentResettingIterator<T>(input.iterator()));
    }

    @Override
    protected Option<T> getElement() {
        int outputIndex;
        if (this.outputElement != null) {
            outputIndex = this.outputElement.getArgumentId();
            if (this.currentIndex < outputIndex) {
                return Option.empty(this.input.get(this.currentIndex++).getArgumentId());
            }
            if (this.currentIndex == outputIndex && !this.outputElement.isEmpty()) {
                return this.input.get(this.currentIndex++);
            }
        }
        while (this.output.hasNext()) {
            this.outputElement = this.output.next();
            outputIndex = this.outputElement.getArgumentId();
            if ((outputIndex != this.currentIndex || this.outputElement.isEmpty()) && outputIndex <= this.currentIndex) continue;
            return this.getElement();
        }
        return null;
    }
}

