/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.iterator.AbstractIterator;

public class FilteringIterator<T>
extends AbstractIterator<Option<T>> {
    private final Iterator<Option<T>> iterator;
    private final Predicate<T> predicate;

    public FilteringIterator(Iterator<Option<T>> iterator, Predicate<T> predicate) {
        this.iterator = iterator;
        this.predicate = predicate;
    }

    @Override
    protected Option<T> getElement() {
        if (this.iterator.hasNext()) {
            Option<T> element = this.iterator.next();
            if (element.isEmpty() || this.predicate.test(element.getElement())) {
                return element;
            }
            return Option.empty(element.getArgumentId());
        }
        return null;
    }
}

