/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.iterator;

import java.util.Iterator;
import org.apache.sling.query.iterator.AbstractIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarningIterator<T>
extends AbstractIterator<T> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"SlingQuery");
    private static final int DEFAULT_LIMIT = 100;
    private final Iterator<T> iterator;
    private final int limit;
    private int count = 0;

    public WarningIterator(Iterator<T> iterator) {
        this(iterator, 100);
    }

    public WarningIterator(Iterator<T> iterator, int limit) {
        this.iterator = iterator;
        this.limit = limit;
    }

    @Override
    protected T getElement() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        if (this.count++ == this.limit) {
            LOG.warn("Number of processed resources exceeded {}. Consider using a JCR query instead of SlingQuery. More info here: https://s.apache.org/oana", new Object[]{this.limit});
        }
        return this.iterator.next();
    }
}

