/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.predicate;

import java.util.function.Predicate;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.util.LazyList;

public class IterableContainsPredicate<T>
implements Predicate<T> {
    private final Iterable<T> iterable;
    private final TreeProvider<T> provider;

    public IterableContainsPredicate(Iterable<T> iterable, TreeProvider<T> provider) {
        this.iterable = new LazyList<T>(iterable.iterator());
        this.provider = provider;
    }

    @Override
    public boolean test(T element) {
        for (T t : this.iterable) {
            if (!this.provider.sameElement(t, element)) continue;
            return true;
        }
        return false;
    }
}

