/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.selector;

import java.util.function.Function;
import org.apache.sling.query.api.SearchStrategy;
import org.apache.sling.query.api.internal.TreeProvider;
import org.apache.sling.query.function.ChildrenFunction;
import org.apache.sling.query.function.FindFunction;
import org.apache.sling.query.function.IdentityFunction;
import org.apache.sling.query.function.NextFunction;
import org.apache.sling.query.predicate.RejectingPredicate;
import org.apache.sling.query.selector.parser.SelectorSegment;

public enum HierarchyOperator {
    CHILD('>'){

        @Override
        public <T> Function<?, ?> getFunction(SelectorSegment segment, SearchStrategy strategy, TreeProvider<T> provider) {
            return new ChildrenFunction<T>(provider);
        }
    }
    ,
    DESCENDANT(' '){

        @Override
        public <T> Function<?, ?> getFunction(SelectorSegment segment, SearchStrategy strategy, TreeProvider<T> provider) {
            return new FindFunction<T>(strategy, provider, segment);
        }
    }
    ,
    NEXT_ADJACENT('+'){

        @Override
        public <T> Function<?, ?> getFunction(SelectorSegment segment, SearchStrategy strategy, TreeProvider<T> provider) {
            return new NextFunction<T>(null, provider);
        }
    }
    ,
    NEXT_SIBLINGS('~'){

        @Override
        public <T> Function<?, ?> getFunction(SelectorSegment segment, SearchStrategy strategy, TreeProvider<T> provider) {
            return new NextFunction(new RejectingPredicate(), provider);
        }
    }
    ,
    NOOP('\u0000'){

        @Override
        public <T> Function<?, ?> getFunction(SelectorSegment segment, SearchStrategy strategy, TreeProvider<T> provider) {
            return new IdentityFunction();
        }
    };

    private final char c;

    private HierarchyOperator(char c) {
        this.c = c;
    }

    public abstract <T> Function<?, ?> getFunction(SelectorSegment var1, SearchStrategy var2, TreeProvider<T> var3);

    public static HierarchyOperator findByCharacter(char c) {
        for (HierarchyOperator operator : HierarchyOperator.values()) {
            if (operator.c != c) continue;
            return operator;
        }
        return NOOP;
    }
}

