/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.selector.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.query.selector.parser.Attribute;
import org.apache.sling.query.selector.parser.Modifier;
import org.apache.sling.query.selector.parser.Selector;
import org.apache.sling.query.selector.parser.SelectorSegment;
import org.apache.sling.query.selector.parser.State;

public class ParserContext {
    private final List<Selector> selectors = new ArrayList<Selector>();
    private final List<SelectorSegment> segments = new ArrayList<SelectorSegment>();
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<Modifier> modifiers = new ArrayList<Modifier>();
    private char hierarchyOperator;
    private State state = State.START;
    private StringBuilder builder = new StringBuilder();
    private String type;
    private String name;
    private String attributeKey;
    private String attributeOperator;
    private String attributeValue;
    private String currentModifierName;
    private int parenthesesCount = 0;

    List<Attribute> getAttributes() {
        return this.attributes;
    }

    List<Modifier> getModifiers() {
        return this.modifiers;
    }

    String getType() {
        return this.type;
    }

    String getName() {
        return this.name;
    }

    char getHierarchyOperator() {
        return this.hierarchyOperator;
    }

    public State getState() {
        return this.state;
    }

    void increaseParentheses() {
        ++this.parenthesesCount;
    }

    int decreaseParentheses() {
        return --this.parenthesesCount;
    }

    void setType() {
        this.type = this.builder.toString();
        this.builder = new StringBuilder();
    }

    void setName() {
        this.name = this.builder.toString();
        this.builder = new StringBuilder();
    }

    void setAttributeKey() {
        this.attributeKey = this.builder.toString();
        this.builder = new StringBuilder();
    }

    void setAttributeOperator() {
        this.attributeOperator = this.builder.toString();
        this.builder = new StringBuilder();
    }

    void setAttributeValue() {
        this.attributeValue = this.builder.toString();
        this.builder = new StringBuilder();
    }

    void addAttribute() {
        this.attributes.add(new Attribute(this.attributeKey, this.attributeOperator, this.attributeValue));
        this.attributeKey = null;
        this.attributeOperator = null;
        this.attributeValue = null;
    }

    void setModifierName() {
        this.currentModifierName = this.builder.toString();
        this.builder = new StringBuilder();
    }

    void addModifier() {
        Modifier modifier;
        if (this.currentModifierName == null) {
            modifier = new Modifier(this.builder.toString(), null);
        } else {
            modifier = new Modifier(this.currentModifierName, this.builder.toString());
            this.currentModifierName = null;
        }
        this.modifiers.add(modifier);
        this.builder = new StringBuilder();
    }

    void setState(State state) {
        this.state = state;
    }

    void setHierarchyOperator(char hierarchyOperator) {
        this.hierarchyOperator = hierarchyOperator;
    }

    void finishSelectorSegment() {
        this.segments.add(new SelectorSegment(this, this.segments.isEmpty()));
        this.attributes.clear();
        this.modifiers.clear();
        this.hierarchyOperator = (char)32;
        this.type = null;
        this.name = null;
    }

    void finishSelector() {
        this.selectors.add(new Selector(this.segments));
        this.segments.clear();
    }

    void append(char c) {
        this.builder.append(c);
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }
}

