/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LazyList<E>
implements List<E> {
    private final List<E> arrayList = new ArrayList();
    private final Iterator<E> iterator;

    public LazyList(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    private void fillAll() {
        while (this.fillNext() != -1) {
        }
    }

    private void fillToSize(int size) {
        for (int s = this.arrayList.size(); s < size && this.fillNext() != -1; ++s) {
        }
    }

    private int fillNext() {
        if (this.iterator.hasNext()) {
            E element = this.iterator.next();
            this.arrayList.add(element);
            return this.arrayList.size() - 1;
        }
        return -1;
    }

    @Override
    public int size() {
        this.fillAll();
        return this.arrayList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.isEmpty() && !this.iterator.hasNext();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new LazyListIterator();
    }

    @Override
    public Object[] toArray() {
        this.fillAll();
        return this.arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.fillAll();
        return this.arrayList.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        this.fillToSize(index + 1);
        return this.arrayList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        int addedIndex;
        int index = this.arrayList.indexOf(o);
        if (index > -1) {
            return index;
        }
        while ((addedIndex = this.fillNext()) != -1) {
            E element = this.arrayList.get(addedIndex);
            if (element == null && o == null) {
                return addedIndex;
            }
            if (element == null || !element.equals(o)) continue;
            return addedIndex;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.fillAll();
        return this.arrayList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new LazyListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new LazyListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.fillToSize(toIndex);
        return this.arrayList.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        this.fillAll();
        return this.arrayList.equals(o);
    }

    @Override
    public int hashCode() {
        this.fillAll();
        return this.arrayList.hashCode();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    private final class LazyListIterator
    implements ListIterator<E> {
        private int index = 0;

        private LazyListIterator() {
            this.index = 0;
        }

        private LazyListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            LazyList.this.fillToSize(this.index + 1);
            return LazyList.this.arrayList.size() > this.index;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return LazyList.this.arrayList.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            LazyList.this.fillToSize(this.index);
            return LazyList.this.arrayList.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

