/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resource.collection.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.resource.collection.ResourceCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCollectionImpl
implements ResourceCollection {
    private static final Logger log = LoggerFactory.getLogger(ResourceCollectionImpl.class);
    private static final String RESOURCE_TYPE = "sling:resourceType";
    private final Resource resource;
    private final ResourceResolver resolver;
    private final Resource membersResource;

    public ResourceCollectionImpl(Resource resource) {
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        this.membersResource = resource.getChild("sling:members");
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public String getPath() {
        return this.resource.getPath();
    }

    @Override
    public boolean add(Resource res, Map<String, Object> properties) throws PersistenceException {
        if (res != null && !this.contains(res)) {
            ModifiableValueMap vm = (ModifiableValueMap)this.membersResource.adaptTo(ModifiableValueMap.class);
            Object[] order = (String[])vm.get("sling:resources", (Object)new String[0]);
            order = (String[])ArrayUtils.add((Object[])order, (Object)res.getPath());
            vm.put((Object)"sling:resources", (Object)order);
            if (properties == null) {
                properties = new HashMap<String, Object>();
            }
            properties.put("sling:resource", res.getPath());
            this.resolver.create(this.membersResource, ResourceUtil.createUniqueChildName((Resource)this.membersResource, (String)res.getName()), properties);
            log.debug("added member to resource {} to collection {}", (Object[])new String[]{res.getPath(), this.resource.getPath()});
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Resource res) throws PersistenceException {
        if (res != null && !this.contains(res)) {
            ModifiableValueMap vm = (ModifiableValueMap)this.membersResource.adaptTo(ModifiableValueMap.class);
            Object[] order = (String[])vm.get("sling:resources", (Object)new String[0]);
            order = (String[])ArrayUtils.add((Object[])order, (Object)res.getPath());
            vm.put((Object)"sling:resources", (Object)order);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("sling:resource", res.getPath());
            this.resolver.create(this.membersResource, ResourceUtil.createUniqueChildName((Resource)this.membersResource, (String)res.getName()), properties);
            log.debug("added member to resource {} to collection {}", (Object[])new String[]{res.getPath(), this.resource.getPath()});
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Resource> getResources() {
        ValueMap vm = (ValueMap)this.membersResource.adaptTo(ValueMap.class);
        String[] references = (String[])vm.get("sling:resources", (Object)new String[0]);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : references) {
            Resource resource = this.resolver.getResource(path);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources.iterator();
    }

    public String getType() {
        return this.resource.getResourceType();
    }

    @Override
    public boolean contains(Resource res) {
        if (res != null) {
            ValueMap vm = (ValueMap)this.membersResource.adaptTo(ValueMap.class);
            Object[] order = (String[])vm.get("sling:resources", (Object)new String[0]);
            int index = ArrayUtils.indexOf((Object[])order, (Object)res.getPath(), (int)0);
            return index >= 0;
        }
        return false;
    }

    @Override
    public boolean remove(Resource res) throws PersistenceException {
        Resource tobeRemovedRes = this.findRes(res);
        if (tobeRemovedRes == null) {
            return false;
        }
        this.resolver.delete(tobeRemovedRes);
        ModifiableValueMap vm = (ModifiableValueMap)this.membersResource.adaptTo(ModifiableValueMap.class);
        Object[] order = (String[])vm.get("sling:resources", (Object)new String[0]);
        int index = ArrayUtils.indexOf((Object[])order, (Object)res.getPath(), (int)0);
        order = (String[])ArrayUtils.remove((Object[])order, (int)index);
        vm.put((Object)"sling:resources", (Object)order);
        return true;
    }

    public void setType(String type) throws PersistenceException {
        ModifiableValueMap mvp = (ModifiableValueMap)this.resource.adaptTo(ModifiableValueMap.class);
        mvp.put((Object)RESOURCE_TYPE, (Object)type);
    }

    private Resource findRes(Resource res) {
        if (res != null) {
            String resName = res.getName();
            if (this.membersResource.getChild(resName) != null && res.getPath().equals(ResourceUtil.getValueMap((Resource)this.membersResource.getChild(resName)).get("sling:resource", (Object)""))) {
                return this.membersResource.getChild(resName);
            }
            Iterator children = this.membersResource.listChildren();
            while (children.hasNext()) {
                Resource r = (Resource)children.next();
                if (!((String)ResourceUtil.getValueMap((Resource)r).get("sling:resource", (Object)"")).equals(res.getPath())) continue;
                return r;
            }
        }
        return null;
    }

    @Override
    public void orderBefore(Resource srcResource, Resource destResource) {
        String srcPath;
        if (srcResource == null) {
            throw new IllegalArgumentException("Source Resource can not be null");
        }
        ModifiableValueMap vm = (ModifiableValueMap)this.membersResource.adaptTo(ModifiableValueMap.class);
        Object[] order = (String[])vm.get("sling:resources", (Object)new String[0]);
        int srcIndex = ArrayUtils.indexOf((Object[])order, (Object)(srcPath = srcResource.getPath()));
        if (srcIndex < 0) {
            log.warn("Collection ordering failed, as there is no resource {} in collection {} for destResource", (Object)srcPath, (Object)this.getPath());
            return;
        }
        if (destResource == null) {
            order = (String[])ArrayUtils.remove((Object[])order, (int)srcIndex);
            order = (String[])ArrayUtils.add((Object[])order, (Object)srcPath);
        } else {
            String destPath = destResource.getPath();
            if (destPath.equals(srcPath)) {
                String message = MessageFormat.format("Collection ordering failed, as source {0} and destination {1} can not be same", srcPath, destPath);
                log.error(message);
                throw new IllegalArgumentException(message);
            }
            int destIndex = ArrayUtils.indexOf((Object[])order, (Object)destPath);
            if (destIndex < 0) {
                log.warn("Collection ordering failed, as there is no resource {} in collection {} for destResource", (Object)destPath, (Object)this.getPath());
                return;
            }
            order = (String[])ArrayUtils.remove((Object[])order, (int)srcIndex);
            if (srcIndex < destIndex) {
                destIndex = ArrayUtils.indexOf((Object[])order, (Object)destPath);
            }
            order = (String[])ArrayUtils.add((Object[])order, (int)destIndex, (Object)srcPath);
        }
        vm.put((Object)"sling:resources", (Object)order);
    }

    @Override
    public ModifiableValueMap getProperties(Resource resource) {
        Iterator entries = this.membersResource.listChildren();
        while (entries.hasNext()) {
            Resource entry = (Resource)entries.next();
            String path = (String)ResourceUtil.getValueMap((Resource)entry).get("sling:resource", (Object)"");
            if (!resource.getPath().equals(path)) continue;
            return (ModifiableValueMap)entry.adaptTo(ModifiableValueMap.class);
        }
        return null;
    }
}

