/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.util.Arrays;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.TransformerFactory;
import org.apache.sling.rewriter.impl.FactoryCache;
import org.apache.sling.rewriter.impl.HashingServiceTrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class TransformerFactoryServiceTracker<T>
extends HashingServiceTrackerCustomizer<T> {
    public static final FactoryCache.TransformerFactoryEntry[] EMPTY_ENTRY_ARRAY = new FactoryCache.TransformerFactoryEntry[0];
    public static final FactoryCache.TransformerFactoryEntry[][] EMPTY_DOUBLE_ENTRY_ARRAY = new FactoryCache.TransformerFactoryEntry[][]{EMPTY_ENTRY_ARRAY, EMPTY_ENTRY_ARRAY};
    public static final TransformerFactory[] EMPTY_FACTORY_ARRAY = new TransformerFactory[0];
    public static final TransformerFactory[][] EMPTY_DOUBLE_FACTORY_ARRAY = new TransformerFactory[][]{EMPTY_FACTORY_ARRAY, EMPTY_FACTORY_ARRAY};
    private FactoryCache.TransformerFactoryEntry[][] cached = EMPTY_DOUBLE_ENTRY_ARRAY;
    private boolean cacheIsValid = true;

    private String getMode(ServiceReference ref) {
        String mode = (String)ref.getProperty("pipeline.mode");
        return mode;
    }

    private boolean isGlobal(ServiceReference ref) {
        return "global".equalsIgnoreCase(this.getMode(ref));
    }

    public TransformerFactoryServiceTracker(BundleContext bc, String serviceClassName) {
        super(bc, serviceClassName);
    }

    @Override
    public Object addingService(ServiceReference reference) {
        Object obj;
        boolean isGlobal = this.isGlobal(reference);
        if (isGlobal) {
            this.cacheIsValid = false;
        }
        if ((obj = super.addingService(reference)) == null && isGlobal) {
            obj = this.context.getService(reference);
        }
        return obj;
    }

    @Override
    public void removedService(ServiceReference reference, Object service) {
        if (this.isGlobal(reference)) {
            this.cacheIsValid = false;
        }
        super.removedService(reference, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FactoryCache.TransformerFactoryEntry[][] getGlobalTransformerFactoryEntries() {
        if (!this.cacheIsValid) {
            TransformerFactoryServiceTracker transformerFactoryServiceTracker = this;
            synchronized (transformerFactoryServiceTracker) {
                if (!this.cacheIsValid) {
                    ServiceReference[] refs = this.getServiceReferences();
                    if (refs == null || refs.length == 0) {
                        this.cached = EMPTY_DOUBLE_ENTRY_ARRAY;
                    } else {
                        Arrays.sort(refs, FactoryCache.ServiceReferenceComparator.INSTANCE);
                        int preCount = 0;
                        int postCount = 0;
                        for (ServiceReference ref : refs) {
                            int ranking;
                            if (!this.isGlobal(ref)) continue;
                            Object r = ref.getProperty("service.ranking");
                            int n = ranking = r instanceof Integer ? (Integer)r : 0;
                            if (ranking < 0) {
                                ++preCount;
                                continue;
                            }
                            ++postCount;
                        }
                        FactoryCache.TransformerFactoryEntry[][] globalFactories = new FactoryCache.TransformerFactoryEntry[][]{preCount == 0 ? EMPTY_ENTRY_ARRAY : new FactoryCache.TransformerFactoryEntry[preCount], postCount == 0 ? EMPTY_ENTRY_ARRAY : new FactoryCache.TransformerFactoryEntry[postCount]};
                        int index = 0;
                        for (ServiceReference ref : refs) {
                            if (!this.isGlobal(ref)) continue;
                            if (index < preCount) {
                                globalFactories[0][index] = new FactoryCache.TransformerFactoryEntry((TransformerFactory)this.getService(ref), ref);
                            } else {
                                globalFactories[1][index - preCount] = new FactoryCache.TransformerFactoryEntry((TransformerFactory)this.getService(ref), ref);
                            }
                            ++index;
                        }
                        this.cached = globalFactories;
                    }
                }
                this.cacheIsValid = true;
            }
        }
        return this.cached;
    }

    public TransformerFactory[][] getGlobalTransformerFactories(ProcessingContext context) {
        FactoryCache.TransformerFactoryEntry[][] globalFactoryEntries = this.getGlobalTransformerFactoryEntries();
        if (globalFactoryEntries == EMPTY_DOUBLE_ENTRY_ARRAY) {
            return EMPTY_DOUBLE_FACTORY_ARRAY;
        }
        TransformerFactory[][] factories = new TransformerFactory[2][];
        for (int i = 0; i < 2; ++i) {
            if (globalFactoryEntries[i] == EMPTY_ENTRY_ARRAY) {
                factories[i] = EMPTY_FACTORY_ARRAY;
                continue;
            }
            factories[i] = new TransformerFactory[globalFactoryEntries[i].length];
            for (int m = 0; m < globalFactoryEntries[i].length; ++m) {
                FactoryCache.TransformerFactoryEntry entry = globalFactoryEntries[i][m];
                if (!entry.match(context)) continue;
                factories[i][m] = entry.factory;
            }
        }
        return factories;
    }
}

