/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.sling.scripting.java.impl.SlingIOProvider;

public class CompilationUnit
implements org.apache.sling.commons.compiler.CompilationUnit {
    private final SlingIOProvider ioProvider;
    private final String className;
    private final String sourceFile;

    public CompilationUnit(String sourceFile, String className, SlingIOProvider ioProvider) {
        this.className = className;
        this.sourceFile = sourceFile;
        this.ioProvider = ioProvider;
    }

    public String getMainClassName() {
        return this.className;
    }

    public Reader getSource() throws IOException {
        InputStream fr = null;
        try {
            fr = this.ioProvider.getInputStream(this.sourceFile);
            return new InputStreamReader(fr, this.ioProvider.getOptions().getJavaEncoding());
        }
        catch (IOException e) {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public long getLastModified() {
        return this.ioProvider.lastModified(this.sourceFile);
    }
}

