/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.DynamicClassLoader;
import org.apache.sling.commons.compiler.CompilationResult;
import org.apache.sling.commons.compiler.CompilerMessage;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.scripting.java.impl.CompilationUnit;
import org.apache.sling.scripting.java.impl.CompilerOptions;
import org.apache.sling.scripting.java.impl.CompilerUtil;
import org.apache.sling.scripting.java.impl.SlingIOProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServletConfig config;
    private final SlingIOProvider ioProvider;
    private final String className;
    private final String sourcePath;
    private final SlingScriptHelper scriptHelper;
    private volatile Servlet theServlet;
    private volatile long available = 0L;
    private volatile Exception compileException;

    public ServletWrapper(ServletConfig config, SlingIOProvider ioProvider, String servletPath, SlingScriptHelper scriptHelper) {
        this.config = config;
        this.ioProvider = ioProvider;
        this.sourcePath = servletPath;
        this.className = CompilerUtil.mapSourcePath(this.sourcePath).substring(1).replace('/', '.');
        this.scriptHelper = scriptHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block9: {
            try {
                Servlet servlet;
                if (this.available > 0L && this.available < Long.MAX_VALUE) {
                    if (this.available > System.currentTimeMillis()) {
                        response.setDateHeader("Retry-After", this.available);
                        response.sendError(503, "Servlet unavailable.");
                        this.logger.error("Java servlet {} is unavailable.", (Object)this.sourcePath);
                        return;
                    }
                    this.available = 0L;
                }
                if ((servlet = this.getServlet()) instanceof SingleThreadModel) {
                    ServletWrapper servletWrapper = this;
                    synchronized (servletWrapper) {
                        servlet.service((ServletRequest)request, (ServletResponse)response);
                        break block9;
                    }
                }
                servlet.service((ServletRequest)request, (ServletResponse)response);
            }
            catch (UnavailableException ex) {
                int unavailableSeconds = ex.getUnavailableSeconds();
                if (unavailableSeconds <= 0) {
                    unavailableSeconds = 60;
                }
                this.available = System.currentTimeMillis() + (long)unavailableSeconds * 1000L;
                response.sendError(503, ex.getMessage());
                this.logger.error("Java servlet {} is unavailable.", (Object)this.sourcePath);
            }
        }
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
            this.theServlet = null;
        }
    }

    private boolean checkReload() {
        if (this.theServlet != null && this.theServlet.getClass().getClassLoader() instanceof DynamicClassLoader) {
            return !((DynamicClassLoader)this.theServlet.getClass().getClassLoader()).isLive();
        }
        return this.theServlet == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet getServlet() throws Exception {
        if (this.compileException != null) {
            throw this.compileException;
        }
        if (this.checkReload()) {
            ServletWrapper servletWrapper = this;
            synchronized (servletWrapper) {
                if (this.checkReload()) {
                    this.logger.debug("Reloading {}", (Object)this.sourcePath);
                    this.compile();
                }
            }
        }
        return this.theServlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectFields(Servlet servlet) {
        for (Field field : servlet.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Inject.class)) continue;
            field.setAccessible(true);
            try {
                Type type = field.getGenericType();
                if (type instanceof Class) {
                    Class injectedClass = (Class)type;
                    if (injectedClass.isInstance(this.scriptHelper)) {
                        field.set(servlet, this.scriptHelper);
                        continue;
                    }
                    if (injectedClass.isArray()) {
                        Object[] services = this.scriptHelper.getServices(injectedClass.getComponentType(), null);
                        Object arr = Array.newInstance(injectedClass.getComponentType(), services.length);
                        for (int i = 0; i < services.length; ++i) {
                            Array.set(arr, i, services[i]);
                        }
                        field.set(servlet, arr);
                        continue;
                    }
                    field.set(servlet, this.scriptHelper.getService(injectedClass));
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    ParameterizedType ptype = (ParameterizedType)type;
                    if (ptype.getActualTypeArguments().length != 1) {
                        this.logger.warn("Field {} of {} has more than one type parameter.", (Object)field.getName(), (Object)this.sourcePath);
                        continue;
                    }
                    Class collectionType = (Class)ptype.getRawType();
                    if (!collectionType.equals(Collection.class) && !collectionType.equals(List.class)) {
                        this.logger.warn("Field {} of {} was not an injectable collection type.", (Object)field.getName(), (Object)this.sourcePath);
                        continue;
                    }
                    Class serviceType = (Class)ptype.getActualTypeArguments()[0];
                    Object[] services = this.scriptHelper.getServices(serviceType, null);
                    field.set(servlet, Arrays.asList(services));
                    continue;
                }
                this.logger.warn("Field {} of {} was not an injectable type.", (Object)field.getName(), (Object)this.sourcePath);
            }
            catch (IllegalArgumentException e) {
                this.logger.error(String.format("Unable to inject into field %s of %s.", field.getName(), this.sourcePath), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error(String.format("Unable to inject into field %s of %s.", field.getName(), this.sourcePath), (Throwable)e);
            }
            finally {
                field.setAccessible(false);
            }
        }
    }

    private void compile() throws Exception {
        this.logger.debug("Compiling {}", (Object)this.sourcePath);
        this.compileException = null;
        try {
            CompilerOptions opts = this.ioProvider.getForceCompileOptions();
            CompilationUnit unit = new CompilationUnit(this.sourcePath, this.className, this.ioProvider);
            CompilationResult result = this.ioProvider.getCompiler().compile(new org.apache.sling.commons.compiler.CompilationUnit[]{unit}, (Options)opts);
            List errors = result.getErrors();
            this.destroy();
            if (errors != null && errors.size() > 0) {
                throw CompilerException.create(errors, this.sourcePath);
            }
            Servlet servlet = (Servlet)result.loadCompiledClass(this.className).newInstance();
            servlet.init(this.config);
            this.injectFields(servlet);
            this.theServlet = servlet;
        }
        catch (Exception ex) {
            this.compileException = ex;
            throw ex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class CompilerException
    extends ServletException {
        private static final long serialVersionUID = 7353686069328527452L;

        public static CompilerException create(List<CompilerMessage> errors, String fileName) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Compilation errors in ");
            buffer.append(fileName);
            buffer.append(":\n");
            for (CompilerMessage e : errors) {
                buffer.append("Line ");
                buffer.append(e.getLine());
                buffer.append(", column ");
                buffer.append(e.getColumn());
                buffer.append(" : ");
                buffer.append(e.getMessage());
                buffer.append("\n");
            }
            return new CompilerException(buffer.toString());
        }

        public CompilerException(String message) {
            super(message);
        }
    }
}

