/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.internal;

import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.javascript.helper.SlingWrapFactory;
import org.apache.sling.scripting.javascript.internal.RhinoJavaScriptEngineFactory;
import org.apache.sling.scripting.javascript.io.EspReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoJavaScriptEngine
extends AbstractSlingScriptEngine {
    private Scriptable rootScope;

    public RhinoJavaScriptEngine(ScriptEngineFactory factory, Scriptable rootScope) {
        super(factory);
        this.rootScope = rootScope;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(Reader scriptReader, ScriptContext scriptContext) throws ScriptException {
        Object object;
        Scriptable scope;
        Map<String, Object> replacedProperties;
        block15: {
            Bindings bindings = scriptContext.getBindings(100);
            String scriptName = "NO_SCRIPT_NAME";
            SlingScriptHelper helper = (SlingScriptHelper)bindings.get("sling");
            if (helper != null) {
                scriptName = helper.getScript().getScriptResource().getPath();
            }
            if (scriptName.endsWith("esp")) {
                scriptReader = new EspReader(scriptReader);
            }
            replacedProperties = null;
            scope = null;
            boolean isTopLevelCall = false;
            try {
                Context rhinoContext = Context.enter();
                rhinoContext.setOptimizationLevel(this.optimizationLevel());
                if (ScriptRuntime.hasTopCall(rhinoContext)) {
                    scope = ScriptRuntime.getTopCallScope(rhinoContext);
                } else {
                    scope = new ImporterTopLevel();
                    scope.setPrototype(this.rootScope);
                    scope.setParentScope(null);
                    SlingWrapFactory wrapFactory = ((RhinoJavaScriptEngineFactory)((Object)this.getFactory())).getWrapFactory();
                    rhinoContext.setWrapFactory(wrapFactory);
                    isTopLevelCall = true;
                }
                replacedProperties = this.setBoundProperties(scope, bindings);
                boolean lineNumber = true;
                Object securityDomain = null;
                Object result = rhinoContext.evaluateReader(scope, scriptReader, scriptName, 1, securityDomain);
                if (result instanceof Wrapper) {
                    result = ((Wrapper)result).unwrap();
                }
                Object object2 = object = result instanceof Undefined ? null : result;
                if (!isTopLevelCall) break block15;
            }
            catch (JavaScriptException t) {
                try {
                    isTopLevelCall = false;
                    ScriptException se = new ScriptException(t.details(), t.sourceName(), t.lineNumber());
                    ((Logger)bindings.get("log")).error(t.getScriptStackTrace());
                    Object value = t.getValue();
                    if (value != null) {
                        if (value instanceof Wrapper) {
                            value = ((Wrapper)value).unwrap();
                        }
                        if (value instanceof Throwable) {
                            se.initCause((Throwable)value);
                        }
                    }
                    if (se.getCause() == null) {
                        se.setStackTrace(t.getStackTrace());
                    }
                    throw se;
                    catch (Throwable t2) {
                        isTopLevelCall = false;
                        se = new ScriptException("Failure running script " + scriptName + ": " + t2.getMessage());
                        se.initCause(t2);
                        throw se;
                    }
                }
                catch (Throwable throwable) {
                    if (isTopLevelCall) {
                        this.getBoundProperties(scope, bindings);
                    }
                    this.resetBoundProperties(scope, replacedProperties);
                    Context.exit();
                    throw throwable;
                }
            }
            this.getBoundProperties(scope, bindings);
        }
        this.resetBoundProperties(scope, replacedProperties);
        Context.exit();
        return object;
    }

    private Map<String, Object> setBoundProperties(Scriptable scope, Bindings bindings) {
        HashMap<String, Object> replacedProperties = new HashMap<String, Object>();
        Iterator i$ = bindings.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = i$.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (ScriptableObject.hasProperty(scope, name)) {
                replacedProperties.put(name, ScriptableObject.getProperty(scope, name));
            }
            Scriptable wrapped = ScriptRuntime.toObject(scope, value);
            ScriptableObject.putProperty(scope, name, (Object)wrapped);
        }
        return replacedProperties;
    }

    private void getBoundProperties(Scriptable scope, Bindings bindings) {
        Object[] ids;
        for (Object id : ids = scope.getIds()) {
            String key;
            Object value;
            if (!(id instanceof String) || (value = scope.get(key = (String)id, scope)) == Scriptable.NOT_FOUND) continue;
            if (value instanceof Wrapper) {
                bindings.put(key, ((Wrapper)value).unwrap());
                continue;
            }
            bindings.put(key, value);
        }
    }

    private void resetBoundProperties(Scriptable scope, Map<String, Object> properties) {
        if (scope != null && properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                ScriptableObject.putProperty(scope, entry.getKey(), entry.getValue());
            }
        }
    }

    private int optimizationLevel() {
        return ((RhinoJavaScriptEngineFactory)((Object)this.getFactory())).getOptimizationLevel();
    }
}

