/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptableBase
extends ScriptableObject {
    private NativeJavaObject njo;
    private final Set<String> jsMethods = this.getJsMethodNames();
    public static final String JSFUNC_PREFIX = "jsFunction_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getNative(String name, Scriptable start) {
        Object wrapped = this.getWrappedObject();
        if (wrapped == null) {
            return Scriptable.NOT_FOUND;
        }
        if (this.jsMethods.contains(name)) {
            return Scriptable.NOT_FOUND;
        }
        if (this.njo == null) {
            ScriptableBase scriptableBase = this;
            synchronized (scriptableBase) {
                if (this.njo == null) {
                    this.njo = new NativeJavaObject(start, wrapped, this.getStaticType());
                }
            }
        }
        return this.njo.get(name, start);
    }

    protected abstract Object getWrappedObject();

    protected abstract Class<?> getStaticType();

    private Set<String> getJsMethodNames() {
        HashSet<String> result = new HashSet<String>();
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().startsWith(JSFUNC_PREFIX)) continue;
            result.add(m.getName().substring(JSFUNC_PREFIX.length()));
        }
        return result;
    }
}

