/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.apache.sling.scripting.javascript.wrapper.ScriptableBase;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptableProperty
extends ScriptableBase
implements SlingWrapper {
    public static final String CLASSNAME = "Property";
    public static final Class<?>[] WRAPPED_CLASSES = new Class[]{Property.class};
    private Property property;

    public void jsConstructor(Object res) {
        this.property = (Property)res;
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    @Override
    public Class<?>[] getWrappedClasses() {
        return WRAPPED_CLASSES;
    }

    public Object jsGet_value() {
        try {
            return this.property.getValue();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_values() {
        try {
            return this.property.getValues();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_string() {
        try {
            return this.property.getString();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_stream() {
        try {
            return this.property.getStream();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_long() {
        try {
            return this.property.getLong();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_double() {
        try {
            return this.property.getDouble();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_date() {
        try {
            return this.property.getDate();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_boolean() {
        try {
            return this.property.getBoolean();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_node() {
        try {
            return ScriptRuntime.toObject(this, this.property.getValue());
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsGet_length() {
        try {
            return this.property.getLength();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public long[] jsGet_lengths() {
        try {
            return this.property.getLengths();
        }
        catch (RepositoryException re) {
            return new long[0];
        }
    }

    public Object jsGet_definition() {
        try {
            return this.property.getDefinition();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public int getType() {
        try {
            return this.property.getType();
        }
        catch (RepositoryException re) {
            return 0;
        }
    }

    public Object jsGet_session() {
        try {
            return this.property.getSession();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public String jsGet_path() {
        try {
            return this.property.getPath();
        }
        catch (RepositoryException e) {
            return this.property.toString();
        }
    }

    public String jsGet_name() {
        try {
            return this.property.getName();
        }
        catch (RepositoryException e) {
            return this.property.toString();
        }
    }

    public Object jsGet_parent() {
        try {
            return ScriptRuntime.toObject(this, this.property.getParent());
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public int jsGet_depth() {
        try {
            return this.property.getDepth();
        }
        catch (RepositoryException re) {
            return -1;
        }
    }

    public boolean jsGet_new() {
        return this.property.isNew();
    }

    public boolean jsGet_modified() {
        return this.property.isModified();
    }

    public Object jsFunction_valueOf(String hint) {
        if ("undefined".equals(hint)) {
            try {
                switch (this.property.getType()) {
                    case 6: {
                        return this.property.getBoolean();
                    }
                    case 5: {
                        return this.property.getDate();
                    }
                    case 4: {
                        return this.property.getDouble();
                    }
                    case 3: {
                        return this.property.getLong();
                    }
                }
                return this.toString();
            }
            catch (RepositoryException re) {
                return this.toString();
            }
        }
        if ("object".equals(hint)) {
            return this;
        }
        if ("function".equals(hint)) {
            return Undefined.instance;
        }
        if ("boolean".equals(hint)) {
            try {
                this.property.getBoolean();
            }
            catch (RepositoryException re) {
                return false;
            }
        }
        if ("number".equals(hint)) {
            try {
                this.property.getDouble();
            }
            catch (RepositoryException re) {
                return 0.0;
            }
        }
        return this.toString();
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object fromSuperclass = super.get(name, start);
        if (fromSuperclass != Scriptable.NOT_FOUND) {
            return fromSuperclass;
        }
        if (this.property == null) {
            return Undefined.instance;
        }
        return this.getNative(name, start);
    }

    public Object jsFunction_toString() {
        return this.toString();
    }

    public String toString() {
        if (this.property != null) {
            try {
                return this.property.getValue().getString();
            }
            catch (RepositoryException e) {
                return this.property.toString();
            }
        }
        return String.valueOf((Object)null);
    }

    @Override
    public Object unwrap() {
        return this.property;
    }

    @Override
    protected Class<?> getStaticType() {
        return Property.class;
    }

    @Override
    protected Object getWrappedObject() {
        return this.property;
    }
}

