/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptablePrintWriter
extends ScriptableObject
implements SlingWrapper {
    public static final String CLASSNAME = "PrintWriter";
    private static final Class<?>[] WRAPPED_CLASSES = new Class[]{PrintWriter.class};
    private PrintWriter writer;
    private Locale locale;

    public ScriptablePrintWriter() {
    }

    public ScriptablePrintWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void jsConstructor(Object res) {
        this.writer = (PrintWriter)res;
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    @Override
    public Class<?>[] getWrappedClasses() {
        return WRAPPED_CLASSES;
    }

    public static void jsFunction_write(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptablePrintWriter.print(thisObj, args);
    }

    public static void jsFunction_print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptablePrintWriter.print(thisObj, args);
    }

    public static void jsFunction_printf(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length > 0) {
            int nextIdx = 0;
            Locale locale = null;
            if (args[nextIdx] instanceof Locale) {
                locale = (Locale)args[nextIdx];
                ++nextIdx;
            } else {
                locale = ((ScriptablePrintWriter)thisObj).getLocale();
            }
            if (args.length > nextIdx) {
                String format = ScriptRuntime.toString(args[nextIdx]);
                Object[] formatArgs = new Object[args.length - ++nextIdx];
                System.arraycopy(args, nextIdx, formatArgs, 0, formatArgs.length);
                PrintWriter writer = ((ScriptablePrintWriter)thisObj).writer;
                writer.printf(locale, format, formatArgs);
            }
        }
    }

    public static void jsFunction_println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptablePrintWriter.print(thisObj, args).println();
    }

    @Override
    public Object unwrap() {
        return this.writer;
    }

    private static PrintWriter print(Object thisObj, Object[] args) {
        PrintWriter writer = ((ScriptablePrintWriter)thisObj).writer;
        for (Object arg : args) {
            writer.print(ScriptRuntime.toString(arg));
        }
        return writer;
    }

    private Locale getLocale() {
        if (this.locale == null) {
            try {
                Object wrapped;
                Object reqObj = ScriptRuntime.name(Context.getCurrentContext(), this, "request");
                if (reqObj instanceof Wrapper && (wrapped = ((Wrapper)reqObj).unwrap()) instanceof HttpServletRequest) {
                    this.locale = ((HttpServletRequest)wrapped).getLocale();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
        }
        return this.locale;
    }
}

