/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.jcr.resource.JcrResourceUtil;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.apache.sling.scripting.javascript.wrapper.ScriptableBase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptableNode
extends ScriptableBase
implements SlingWrapper {
    public static final String CLASSNAME = "Node";
    private static final Class<?>[] WRAPPED_CLASSES = new Class[]{Node.class};
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Node node;

    public void jsConstructor(Object res) {
        this.node = (Node)res;
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    @Override
    public Class<?>[] getWrappedClasses() {
        return WRAPPED_CLASSES;
    }

    @Override
    protected Class<?> getStaticType() {
        return Node.class;
    }

    @Override
    protected Object getWrappedObject() {
        return this.node;
    }

    public Object jsFunction_addNode(String path, String primaryType) throws RepositoryException {
        Node n = null;
        n = primaryType == null || "undefined".equals(primaryType) ? this.node.addNode(path) : this.node.addNode(path, primaryType);
        Scriptable result = ScriptRuntime.toObject(this, n);
        return result;
    }

    public Object jsFunction_getNode(String path) throws RepositoryException {
        return ScriptRuntime.toObject(this, this.node.getNode(path));
    }

    public Object jsFunction_getChildren() {
        try {
            return this.toScriptableItemMap((Iterator<?>)this.node.getNodes());
        }
        catch (RepositoryException re) {
            this.log.warn("Cannot get children of " + this.jsFunction_getPath(), (Throwable)re);
            return this.toScriptableItemMap(null);
        }
    }

    public Object jsFunction_getNodes(String namePattern) {
        try {
            NodeIterator iter = null;
            iter = namePattern == null || "undefined".equals(namePattern) ? this.node.getNodes() : this.node.getNodes(namePattern);
            return this.toScriptableItemMap((Iterator<?>)iter);
        }
        catch (RepositoryException re) {
            this.log.warn("Cannot get children of " + this.jsFunction_getPath() + " with pattern " + namePattern, (Throwable)re);
            return this.toScriptableItemMap(null);
        }
    }

    public Object jsFunction_getProperties() {
        try {
            return this.toScriptableItemMap((Iterator<?>)this.node.getProperties());
        }
        catch (RepositoryException re) {
            this.log.warn("Cannot get properties of " + this.jsFunction_getPath(), (Throwable)re);
            return this.toScriptableItemMap(null);
        }
    }

    public Object jsFunction_getPrimaryItem() {
        try {
            return ScriptRuntime.toObject(this, this.node.getPrimaryItem());
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsFunction_getProperty(String name) throws RepositoryException {
        Object[] args = new Object[]{this.node.getProperty(name)};
        return ScriptRuntime.newObject(Context.getCurrentContext(), this, "Property", args);
    }

    public String jsFunction_getUUID() {
        try {
            return this.node.getUUID();
        }
        catch (RepositoryException re) {
            return "";
        }
    }

    public int jsFunction_getIndex() {
        try {
            return this.node.getIndex();
        }
        catch (RepositoryException re) {
            return 1;
        }
    }

    public Iterator<?> jsFunction_getReferences() {
        try {
            return this.node.getReferences();
        }
        catch (RepositoryException re) {
            return Collections.EMPTY_LIST.iterator();
        }
    }

    public Object jsFunction_getPrimaryNodeType() {
        try {
            return this.node.getPrimaryNodeType();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public NodeType[] jsFunction_getMixinNodeTypes() {
        try {
            return this.node.getMixinNodeTypes();
        }
        catch (RepositoryException re) {
            return new NodeType[0];
        }
    }

    public Object jsFunction_getDefinition() {
        try {
            return this.node.getDefinition();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public boolean jsFunction_getCheckedOut() {
        try {
            return this.node.isCheckedOut();
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public Object jsFunction_getVersionHistory() {
        try {
            return ScriptRuntime.toObject(this, this.node.getVersionHistory());
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsFunction_getBaseVersion() {
        try {
            return ScriptRuntime.toObject(this, this.node.getBaseVersion());
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public Object jsFunction_getLock() {
        try {
            return this.node.getLock();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public boolean jsFunction_getLocked() {
        try {
            return this.node.isLocked();
        }
        catch (RepositoryException re) {
            return false;
        }
    }

    public Object jsFunction_getSession() {
        try {
            return this.node.getSession();
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public String jsFunction_getPath() {
        try {
            return this.node.getPath();
        }
        catch (RepositoryException e) {
            return this.node.toString();
        }
    }

    public String jsFunction_getName() {
        try {
            return this.node.getName();
        }
        catch (RepositoryException e) {
            return this.node.toString();
        }
    }

    public Object jsFunction_getParent() {
        try {
            return ScriptRuntime.toObject(this, this.node.getParent());
        }
        catch (RepositoryException re) {
            return Undefined.instance;
        }
    }

    public int jsFunction_getDepth() {
        try {
            return this.node.getDepth();
        }
        catch (RepositoryException re) {
            return -1;
        }
    }

    public boolean jsFunction_getNew() {
        return this.node.isNew();
    }

    public boolean jsFunction_getModified() {
        return this.node.isModified();
    }

    public void jsFunction_remove() throws RepositoryException {
        this.node.remove();
    }

    public boolean jsFunction_hasNode(String path) throws RepositoryException {
        return this.node.hasNode(path);
    }

    @Override
    public Object get(String name, Scriptable start) {
        Object fromSuperclass = super.get(name, start);
        if (fromSuperclass != Scriptable.NOT_FOUND) {
            return fromSuperclass;
        }
        if (this.node == null) {
            return Undefined.instance;
        }
        ArrayList<Scriptable> items = new ArrayList<Scriptable>();
        try {
            NodeIterator it = this.node.getNodes(name);
            while (it.hasNext()) {
                items.add(ScriptRuntime.toObject(this, it.nextNode()));
            }
        }
        catch (RepositoryException e) {
            this.log.debug("RepositoryException while collecting Node children", (Throwable)e);
        }
        boolean isMulti = false;
        try {
            PropertyIterator it = this.node.getProperties(name);
            while (it.hasNext()) {
                Property prop = it.nextProperty();
                if (prop.getDefinition().isMultiple()) {
                    isMulti = true;
                    Value[] values = prop.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        items.add(this.wrap(values[i]));
                    }
                    continue;
                }
                items.add(this.wrap(prop.getValue()));
            }
        }
        catch (RepositoryException e) {
            this.log.debug("RepositoryException while collecting Node properties", (Throwable)e);
        }
        if (items.size() == 0) {
            return this.getNative(name, start);
        }
        if (items.size() == 1 && !isMulti) {
            return items.iterator().next();
        }
        NativeArray result = new NativeArray(items.toArray());
        ScriptRuntime.setObjectProtoAndParent(result, this);
        return result;
    }

    private Scriptable wrap(Value value) throws ValueFormatException, IllegalStateException, RepositoryException {
        Object javaObject;
        if (value.getType() == 9) {
            String nodeUuid = value.getString();
            javaObject = this.node.getSession().getNodeByUUID(nodeUuid);
        } else {
            javaObject = JcrResourceUtil.toJavaObject((Value)value);
        }
        return ScriptRuntime.toObject(this, javaObject);
    }

    @Override
    public Object[] getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.node != null) {
            try {
                PropertyIterator pit = this.node.getProperties();
                while (pit.hasNext()) {
                    ids.add(pit.nextProperty().getName());
                }
            }
            catch (RepositoryException e) {
                // empty catch block
            }
            try {
                NodeIterator nit = this.node.getNodes();
                while (nit.hasNext()) {
                    ids.add(nit.nextNode().getName());
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return ids.toArray();
    }

    public Object getDefaultValue(Class typeHint) {
        return this.toString();
    }

    @Override
    public boolean has(String name, Scriptable start) {
        if (this.node != null) {
            try {
                return this.node.hasProperty(name) || this.node.hasNode(name);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        if (this.node != null) {
            try {
                return this.node.getPath();
            }
            catch (RepositoryException e) {
                return this.node.toString();
            }
        }
        return String.valueOf((Object)null);
    }

    @Override
    public Object unwrap() {
        return this.node;
    }

    private Object toScriptableItemMap(Iterator<?> iter) {
        Object[] objectArray;
        if (iter != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = iter;
        } else {
            objectArray = null;
        }
        Object[] args = objectArray;
        return ScriptRuntime.newObject(Context.getCurrentContext(), this, "ItemMap", args);
    }
}

