/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptableItemMap
extends ScriptableObject {
    public static final String CLASSNAME = "ItemMap";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Item> items = new LinkedHashMap<String, Item>();

    public void jsConstructor(Object res) {
        if (res instanceof Iterator) {
            Iterator itemIterator = (Iterator)res;
            while (itemIterator.hasNext()) {
                Item item = (Item)itemIterator.next();
                try {
                    this.items.put(item.getName(), item);
                }
                catch (RepositoryException re) {
                    this.log.error("ScriptableItemMap<init>: Cannot get name of item " + item, (Throwable)re);
                }
            }
        }
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return this.getItem(index) != null;
    }

    @Override
    public boolean has(String name, Scriptable start) {
        return this.items.containsKey(name);
    }

    @Override
    public Object get(int index, Scriptable start) {
        Item item = this.getItem(index);
        if (item != null) {
            return ScriptRuntime.toObject(this, item);
        }
        return Undefined.instance;
    }

    @Override
    public Object get(String name, Scriptable start) {
        if ("length".equals(name)) {
            return ScriptRuntime.toNumber(this.items.keySet().size() + "");
        }
        Item item = this.items.get(name);
        Object result = Undefined.instance;
        if (item != null) {
            result = ScriptRuntime.toObject(this, item);
        }
        return result;
    }

    @Override
    public Object[] getIds() {
        return this.items.keySet().toArray();
    }

    private Item getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        Iterator<Item> itemsIter = this.items.values().iterator();
        while (itemsIter.hasNext() && index > 0) {
            itemsIter.next();
            --index;
        }
        return itemsIter.hasNext() ? itemsIter.next() : null;
    }
}

