/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.javascript.io.EspReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingGlobal
implements Serializable,
IdFunctionCall {
    static final long serialVersionUID = 6080442165748707530L;
    private static final Object FTAG = new Object();
    private static final int Id_load = 1;
    private static final int Id_print = 2;
    private static final int LAST_SCOPE_FUNCTION_ID = 2;
    private final Logger defaultLog = LoggerFactory.getLogger(this.getClass());

    public static void init(Scriptable scope, boolean sealed) {
        SlingGlobal obj = new SlingGlobal();
        for (int id = 1; id <= 2; ++id) {
            String name;
            int arity = 1;
            switch (id) {
                case 1: {
                    name = "load";
                    break;
                }
                case 2: {
                    name = "print";
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            IdFunctionObject f = new IdFunctionObject(obj, FTAG, id, name, arity, scope);
            if (sealed) {
                f.sealObject();
            }
            f.exportAsScopeProperty();
        }
    }

    @Override
    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (f.hasTag(FTAG)) {
            int methodId = f.methodId();
            switch (methodId) {
                case 1: {
                    this.load(cx, thisObj, args);
                    return Context.getUndefinedValue();
                }
                case 2: {
                    this.print(cx, thisObj, args);
                    return Context.getUndefinedValue();
                }
            }
        }
        throw f.unknown();
    }

    private void print(Context cx, Scriptable thisObj, Object[] args) {
        StringBuffer message = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                message.append(" ");
            }
            String s = ScriptRuntime.toString(args[i]);
            message.append(s);
        }
        this.getLogger(cx, thisObj).info(message.toString());
    }

    private void load(Context cx, Scriptable thisObj, Object[] args) {
        SlingScriptHelper sling = this.getProperty(cx, thisObj, "sling", SlingScriptHelper.class);
        if (sling == null) {
            throw new NullPointerException("sling");
        }
        Scriptable globalScope = ScriptableObject.getTopLevelScope(thisObj);
        Resource scriptResource = sling.getScript().getScriptResource();
        ResourceResolver resolver = scriptResource.getResourceResolver();
        String currentScript = sling.getScript().getScriptResource().getPath();
        String scriptParent = ResourceUtil.getParent((String)currentScript);
        for (Object arg : args) {
            String scriptName = ScriptRuntime.toString(arg);
            Resource loadScript = null;
            if (!scriptName.startsWith("/")) {
                String absScriptName = scriptParent + "/" + scriptName;
                loadScript = resolver.resolve(absScriptName);
            }
            if (loadScript == null) {
                loadScript = resolver.resolve(scriptName);
            }
            if (loadScript == null) {
                throw Context.reportRuntimeError("Script file " + scriptName + " not found");
            }
            InputStream scriptStream = (InputStream)loadScript.adaptTo(InputStream.class);
            if (scriptStream == null) {
                throw Context.reportRuntimeError("Script file " + scriptName + " cannot be read from");
            }
            try {
                Reader scriptReader = new InputStreamReader(scriptStream);
                if (scriptName.endsWith("esp")) {
                    scriptReader = new EspReader(scriptReader);
                }
                scriptReader = new BufferedReader(scriptReader);
                cx.evaluateReader(globalScope, scriptReader, scriptName, 1, null);
            }
            catch (IOException ioe) {
                throw Context.reportRuntimeError("Failure reading file " + scriptName + ": " + ioe);
            }
            finally {
                try {
                    scriptStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private Logger getLogger(Context cx, Scriptable scope) {
        Logger log = this.getProperty(cx, scope, "log", Logger.class);
        if (log == null) {
            log = this.defaultLog;
        }
        return log;
    }

    private <Type> Type getProperty(Context cx, Scriptable scope, String name, Class<Type> type) {
        Object prop = ScriptRuntime.name(cx, scope, name);
        if (prop instanceof Wrapper) {
            prop = ((Wrapper)prop).unwrap();
        }
        if (type.isInstance(prop)) {
            return (Type)prop;
        }
        return null;
    }
}

