/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.internal;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.javascript.helper.SlingWrapFactory;
import org.apache.sling.scripting.javascript.internal.RhinoJavaScriptEngineFactory;
import org.apache.sling.scripting.javascript.io.EspReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoJavaScriptEngine
extends AbstractSlingScriptEngine {
    private Scriptable rootScope;

    public RhinoJavaScriptEngine(ScriptEngineFactory factory, Scriptable rootScope) {
        super(factory);
        this.rootScope = rootScope;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object eval(Reader scriptReader, ScriptContext scriptContext) throws ScriptException {
        Object object;
        Bindings bindings = scriptContext.getBindings(100);
        String scriptName = "NO_SCRIPT_NAME";
        SlingScriptHelper helper = (SlingScriptHelper)bindings.get("sling");
        if (helper != null) {
            scriptName = helper.getScript().getScriptResource().getPath();
        }
        if (scriptName.endsWith("esp")) {
            scriptReader = new EspReader(scriptReader);
        }
        Map<String, Object> replacedProperties = null;
        Scriptable scope = null;
        try {
            Context rhinoContext = Context.enter();
            if (ScriptRuntime.hasTopCall(rhinoContext)) {
                scope = ScriptRuntime.getTopCallScope(rhinoContext);
            } else {
                scope = new ImporterTopLevel();
                scope.setPrototype(this.rootScope);
                scope.setParentScope(null);
                SlingWrapFactory wrapFactory = ((RhinoJavaScriptEngineFactory)((Object)this.getFactory())).getWrapFactory();
                rhinoContext.setWrapFactory(wrapFactory);
            }
            replacedProperties = this.setBoundProperties(scope, bindings);
            boolean lineNumber = true;
            Object securityDomain = null;
            object = rhinoContext.evaluateReader(scope, scriptReader, scriptName, 1, securityDomain);
        }
        catch (JavaScriptException t) {
            try {
                ScriptException se = new ScriptException(t.details(), t.sourceName(), t.lineNumber());
                ((Logger)bindings.get("log")).error(t.getScriptStackTrace());
                Object value = t.getValue();
                if (value != null) {
                    if (value instanceof Wrapper) {
                        value = ((Wrapper)value).unwrap();
                    }
                    if (value instanceof Throwable) {
                        se.initCause((Throwable)value);
                    }
                }
                if (se.getCause() == null) {
                    se.setStackTrace(t.getStackTrace());
                }
                throw se;
                catch (Throwable t2) {
                    se = new ScriptException("Failure running script " + scriptName + ": " + t2.getMessage());
                    se.initCause(t2);
                    throw se;
                }
            }
            catch (Throwable throwable) {
                this.resetBoundProperties(scope, replacedProperties);
                Context.exit();
                throw throwable;
            }
        }
        this.resetBoundProperties(scope, replacedProperties);
        Context.exit();
        return object;
    }

    private Map<String, Object> setBoundProperties(Scriptable scope, Bindings bindings) {
        HashMap<String, Object> replacedProperties = new HashMap<String, Object>();
        for (Map.Entry entryObject : bindings.entrySet()) {
            Map.Entry entry = entryObject;
            String name = (String)entry.getKey();
            if (ScriptableObject.hasProperty(scope, name)) {
                replacedProperties.put(name, ScriptableObject.getProperty(scope, name));
            }
            Scriptable wrapped = ScriptRuntime.toObject(scope, entry.getValue());
            ScriptableObject.putProperty(scope, (String)entry.getKey(), (Object)wrapped);
        }
        return replacedProperties;
    }

    private void resetBoundProperties(Scriptable scope, Map<String, Object> properties) {
        if (scope != null && properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                ScriptableObject.putProperty(scope, entry.getKey(), entry.getValue());
            }
        }
    }
}

