/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.commons.classloader.DynamicClassLoader;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.api.CachedScript;
import org.apache.sling.scripting.api.ScriptCache;
import org.apache.sling.scripting.api.ScriptNameAware;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.javascript.helper.SlingWrapFactory;
import org.apache.sling.scripting.javascript.internal.RhinoJavaScriptEngineFactory;
import org.apache.sling.scripting.javascript.io.EspReader;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhinoJavaScriptEngine
extends AbstractSlingScriptEngine
implements Compilable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RhinoJavaScriptEngine.class);
    private static final String NO_SCRIPT_NAME = "NO_SCRIPT_NAME";
    private Scriptable rootScope;
    private ScriptCache scriptCache;

    public RhinoJavaScriptEngine(ScriptEngineFactory factory, Scriptable rootScope, ScriptCache scriptCache) {
        super(factory);
        this.rootScope = rootScope;
        this.scriptCache = scriptCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledScript compile(String script) throws ScriptException {
        CompiledScript compiledScript;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(IOUtils.toInputStream((String)script));
            compiledScript = this.compile(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return compiledScript;
    }

    @Override
    public CompiledScript compile(Reader scriptReader) throws ScriptException {
        final String scriptName = this.getScriptName(scriptReader);
        CachedScript cachedScript = this.scriptCache.getScript(scriptName);
        if (cachedScript != null) {
            LOGGER.debug("Detected cached script for {}.", (Object)scriptName);
            return cachedScript.getCompiledScript();
        }
        scriptReader = this.wrapReaderIfEspScript(scriptReader, scriptName);
        try {
            Context rhinoContext = Context.enter();
            rhinoContext.setOptimizationLevel(this.optimizationLevel());
            if (!ScriptRuntime.hasTopCall((Context)rhinoContext)) {
                SlingWrapFactory wrapFactory = ((RhinoJavaScriptEngineFactory)((Object)this.getFactory())).getWrapFactory();
                rhinoContext.setWrapFactory((WrapFactory)wrapFactory);
            }
            boolean lineNumber = true;
            Object securityDomain = null;
            Script script = rhinoContext.compileReader(scriptReader, scriptName, 1, securityDomain);
            final SlingCompiledScript slingCompiledScript = new SlingCompiledScript(script, (ScriptEngine)((Object)this));
            cachedScript = new CachedScript(){

                public String getScriptPath() {
                    return scriptName;
                }

                public CompiledScript getCompiledScript() {
                    return slingCompiledScript;
                }
            };
            if (!scriptName.equals(NO_SCRIPT_NAME)) {
                this.scriptCache.putScript(cachedScript);
            }
            LOGGER.debug("Added {} script to Script Cache.", (Object)scriptName);
            SlingCompiledScript slingCompiledScript2 = slingCompiledScript;
            return slingCompiledScript2;
        }
        catch (IOException e) {
            ScriptException se = new ScriptException("Failure running script " + scriptName + ": " + e.getMessage());
            se.initCause(e);
            throw se;
        }
        finally {
            Context.exit();
        }
    }

    public Object eval(Reader scriptReader, ScriptContext scriptContext) throws ScriptException {
        String script;
        String scriptName = this.getScriptName(scriptReader);
        Reader reader = this.wrapReaderIfEspScript(scriptReader, scriptName);
        if (!(scriptReader instanceof ScriptNameAware) && NO_SCRIPT_NAME.equals(scriptName) && (script = (String)scriptContext.getBindings(100).get("javax.script.filename")) != null) {
            for (String extension : this.getFactory().getExtensions()) {
                if (!script.endsWith(extension)) continue;
                scriptName = script;
                reader = new ScriptNameAwareReader(reader, scriptName);
                break;
            }
        }
        return this.compile(reader).eval(scriptContext);
    }

    private Reader wrapReaderIfEspScript(Reader scriptReader, String scriptName) {
        if (scriptName.endsWith("esp")) {
            scriptReader = new EspReader(scriptReader);
        }
        return scriptReader;
    }

    private Map<String, Object> setBoundProperties(Scriptable scope, Bindings bindings) {
        HashMap<String, Object> replacedProperties = new HashMap<String, Object>();
        Iterator iterator = bindings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (ScriptableObject.hasProperty((Scriptable)scope, (String)name)) {
                replacedProperties.put(name, ScriptableObject.getProperty((Scriptable)scope, (String)name));
            }
            Scriptable wrapped = ScriptRuntime.toObject((Scriptable)scope, value);
            ScriptableObject.putProperty((Scriptable)scope, (String)name, (Object)wrapped);
        }
        return replacedProperties;
    }

    private void getBoundProperties(Scriptable scope, Bindings bindings) {
        Object[] ids;
        for (Object id : ids = scope.getIds()) {
            String key;
            Object value;
            if (!(id instanceof String) || (value = scope.get(key = (String)id, scope)) == Scriptable.NOT_FOUND) continue;
            if (value instanceof Wrapper) {
                bindings.put(key, ((Wrapper)value).unwrap());
                continue;
            }
            bindings.put(key, value);
        }
    }

    private void resetBoundProperties(Scriptable scope, Map<String, Object> properties) {
        if (scope != null && properties != null && properties.size() > 0) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                ScriptableObject.putProperty((Scriptable)scope, (String)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    private int optimizationLevel() {
        return ((RhinoJavaScriptEngineFactory)((Object)this.getFactory())).getOptimizationLevel();
    }

    private String getScriptName(Reader scriptReader) {
        if (scriptReader instanceof ScriptNameAware) {
            return ((ScriptNameAware)scriptReader).getScriptName();
        }
        return NO_SCRIPT_NAME;
    }

    private String getScriptName(ScriptContext scriptContext) {
        Bindings bindings = scriptContext.getBindings(100);
        String scriptName = (String)bindings.get("javax.script.filename");
        if (scriptName != null && !"".equals(scriptName)) {
            return scriptName;
        }
        SlingScriptHelper sling = (SlingScriptHelper)bindings.get("sling");
        if (sling != null) {
            return sling.getScript().getScriptResource().getPath();
        }
        return NO_SCRIPT_NAME;
    }

    private class SlingCompiledScript
    extends CompiledScript {
        private final Script script;
        private final ScriptEngine engine;

        SlingCompiledScript(Script script, ScriptEngine engine) {
            this.script = script;
            this.engine = engine;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object eval(ScriptContext scriptContext) throws ScriptException {
            DynamicClassLoader dynamicClassLoader;
            Object object;
            Scriptable scope;
            Map replacedProperties;
            block15: {
                Bindings bindings = scriptContext.getBindings(100);
                replacedProperties = null;
                scope = null;
                boolean isTopLevelCall = false;
                try {
                    Context rhinoContext = Context.enter();
                    rhinoContext.setOptimizationLevel(RhinoJavaScriptEngine.this.optimizationLevel());
                    if (ScriptRuntime.hasTopCall((Context)rhinoContext)) {
                        scope = ScriptRuntime.getTopCallScope((Context)rhinoContext);
                    } else {
                        scope = new ImporterTopLevel();
                        scope.setPrototype(RhinoJavaScriptEngine.this.rootScope);
                        scope.setParentScope(null);
                        SlingWrapFactory wrapFactory = ((RhinoJavaScriptEngineFactory)((Object)RhinoJavaScriptEngine.this.getFactory())).getWrapFactory();
                        rhinoContext.setWrapFactory((WrapFactory)wrapFactory);
                        isTopLevelCall = true;
                    }
                    replacedProperties = RhinoJavaScriptEngine.this.setBoundProperties(scope, bindings);
                    Object result = this.script.exec(rhinoContext, scope);
                    if (result instanceof Wrapper) {
                        result = ((Wrapper)result).unwrap();
                    }
                    Object object2 = object = result instanceof Undefined ? null : result;
                    if (!isTopLevelCall) break block15;
                }
                catch (JavaScriptException t) {
                    try {
                        isTopLevelCall = false;
                        ScriptException se = new ScriptException(t.details(), t.sourceName(), t.lineNumber());
                        ((Logger)bindings.get("log")).error(t.getScriptStackTrace());
                        Object value = t.getValue();
                        if (value != null) {
                            if (value instanceof Wrapper) {
                                value = ((Wrapper)value).unwrap();
                            }
                            if (value instanceof Throwable) {
                                se.initCause((Throwable)value);
                            }
                        }
                        if (se.getCause() == null) {
                            se.setStackTrace(t.getStackTrace());
                        }
                        throw se;
                        catch (Throwable t2) {
                            isTopLevelCall = false;
                            String scriptName = RhinoJavaScriptEngine.this.getScriptName(scriptContext);
                            ScriptException se2 = new ScriptException("Failure running script " + scriptName + ": " + t2.getMessage());
                            se2.initCause(t2);
                            throw se2;
                        }
                    }
                    catch (Throwable throwable) {
                        DynamicClassLoader dynamicClassLoader2;
                        if (isTopLevelCall) {
                            RhinoJavaScriptEngine.this.getBoundProperties(scope, bindings);
                        }
                        RhinoJavaScriptEngine.this.resetBoundProperties(scope, replacedProperties);
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        if (classLoader instanceof DynamicClassLoader && !(dynamicClassLoader2 = (DynamicClassLoader)classLoader).isLive() && scope != null) {
                            ClassCache classCache = ClassCache.get((Scriptable)scope);
                            classCache.clearCaches();
                            LOGGER.info("Detected dirty class loader on thread {}. Emptying Rhino's class cache.", (Object)Thread.currentThread().getName());
                        }
                        Context.exit();
                        throw throwable;
                    }
                }
                RhinoJavaScriptEngine.this.getBoundProperties(scope, bindings);
            }
            RhinoJavaScriptEngine.this.resetBoundProperties(scope, replacedProperties);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader instanceof DynamicClassLoader && !(dynamicClassLoader = (DynamicClassLoader)classLoader).isLive() && scope != null) {
                ClassCache classCache = ClassCache.get((Scriptable)scope);
                classCache.clearCaches();
                LOGGER.info("Detected dirty class loader on thread {}. Emptying Rhino's class cache.", (Object)Thread.currentThread().getName());
            }
            Context.exit();
            return object;
        }

        @Override
        public ScriptEngine getEngine() {
            return this.engine;
        }
    }
}

