/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompileTimeObjectModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileTimeObjectModel.class);
    public static final Set<Class<?>> PRIMITIVE_CLASSES = Collections.unmodifiableSet(new HashSet<Class<?>>(){
        {
            this.add(Boolean.class);
            this.add(Boolean.class);
            this.add(Character.class);
            this.add(Byte.class);
            this.add(Short.class);
            this.add(Integer.class);
            this.add(Long.class);
            this.add(Float.class);
            this.add(Double.class);
            this.add(Void.class);
        }
    });
    public static final String TO_STRING_METHOD = "toString";

    public static boolean isPrimitive(Object obj) {
        return PRIMITIVE_CLASSES.contains(obj.getClass());
    }

    public static Object resolveProperty(Object target, Object property) {
        Object resolved = property instanceof Number ? CompileTimeObjectModel.getIndex(target, ((Number)property).intValue()) : CompileTimeObjectModel.getProperty(target, property);
        return resolved;
    }

    public static boolean toBoolean(Object object) {
        return CompileTimeObjectModel.toBooleanInternal(object);
    }

    public static Number toNumber(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        return 0;
    }

    public static String toString(Object target) {
        return CompileTimeObjectModel.objectToString(target);
    }

    public static Collection<Object> toCollection(Object object) {
        return CompileTimeObjectModel.obtainCollection(object);
    }

    private static String objectToString(Object obj) {
        String output = "";
        if (obj != null) {
            if (obj instanceof String) {
                output = (String)obj;
            } else if (CompileTimeObjectModel.isPrimitive(obj)) {
                output = obj.toString();
            } else {
                if (obj instanceof Enum) {
                    return ((Enum)obj).name();
                }
                Collection<Object> col = CompileTimeObjectModel.obtainCollection(obj);
                if (col != null) {
                    output = CompileTimeObjectModel.collectionToString(col);
                }
            }
        }
        return output;
    }

    private static Object getProperty(Object target, Object propertyObj) {
        String property = CompileTimeObjectModel.toString(propertyObj);
        if (StringUtils.isEmpty((String)property)) {
            throw new IllegalArgumentException("Invalid property name");
        }
        if (target == null) {
            return null;
        }
        Object result = null;
        if (target instanceof Map) {
            result = CompileTimeObjectModel.getMapProperty((Map)target, property);
        }
        if (result == null) {
            result = CompileTimeObjectModel.getObjectProperty(target, property);
        }
        return result;
    }

    private static Collection<Object> obtainCollection(Object obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        if (obj instanceof Object[]) {
            return Arrays.asList((Object[])obj);
        }
        if (obj instanceof Collection) {
            return (Collection)obj;
        }
        if (obj instanceof Map) {
            return ((Map)obj).keySet();
        }
        if (obj instanceof Enumeration) {
            return Collections.list((Enumeration)obj);
        }
        if (obj instanceof Iterator) {
            return CompileTimeObjectModel.fromIterator((Iterator)obj);
        }
        if (obj instanceof Iterable) {
            Iterable iterable = (Iterable)obj;
            return CompileTimeObjectModel.fromIterator(iterable.iterator());
        }
        if (obj instanceof String || obj instanceof Number) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(obj);
            return list;
        }
        return Collections.emptyList();
    }

    private static String collectionToString(Collection<?> col) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (Object o : col) {
            builder.append(prefix).append(CompileTimeObjectModel.objectToString(o));
            prefix = ",";
        }
        return builder.toString();
    }

    private static Collection<Object> fromIterator(Iterator<Object> iterator) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result;
    }

    private static boolean toBooleanInternal(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return number.doubleValue() != 0.0;
        }
        String s = obj.toString().trim();
        if ("".equals(s)) {
            return false;
        }
        if ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s)) {
            return Boolean.parseBoolean(s);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size() > 0;
        }
        if (obj instanceof Map) {
            return ((Map)obj).size() > 0;
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator().hasNext();
        }
        if (obj instanceof Iterator) {
            return ((Iterator)obj).hasNext();
        }
        return !(obj instanceof Object[]) || ((Object[])obj).length > 0;
    }

    private static Object getIndex(Object obj, int index) {
        Map map;
        if (obj instanceof Map && (map = (Map)obj).containsKey(index)) {
            return map.get(index);
        }
        Collection<Object> collection = CompileTimeObjectModel.toCollection(obj);
        if (collection instanceof List) {
            return CompileTimeObjectModel.getIndexSafe((List)collection, index);
        }
        return null;
    }

    private static Object getIndexSafe(List list, int index) {
        if (index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    private static Object getMapProperty(Map map, String property) {
        return map.get(property);
    }

    private static Object getObjectProperty(Object obj, String property) {
        Object result = CompileTimeObjectModel.getObjectNoArgMethod(obj, property);
        if (result == null) {
            result = CompileTimeObjectModel.getField(obj, property);
        }
        return result;
    }

    private static Object getField(Object obj, String property) {
        Class<?> cls = obj.getClass();
        if (cls.isArray() && "length".equals(property)) {
            return Array.getLength(obj);
        }
        try {
            Field field = cls.getDeclaredField(property);
            return field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object getObjectNoArgMethod(Object obj, String property) {
        Class<?> cls = obj.getClass();
        Method method = CompileTimeObjectModel.findMethod(cls, property);
        if (method != null) {
            method = CompileTimeObjectModel.extractMethodInheritanceChain(cls, method);
            try {
                return method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("Cannot access method " + property + " on object " + obj.toString(), (Throwable)e);
            }
        }
        return null;
    }

    private static Method findMethod(Class<?> cls, String baseName) {
        Method[] publicMethods = cls.getMethods();
        String capitalized = StringUtils.capitalize((String)baseName);
        for (Method m : publicMethods) {
            String methodName;
            if (m.getParameterTypes().length != 0 || !baseName.equals(methodName = m.getName()) && !("get" + capitalized).equals(methodName) && !("is" + capitalized).equals(methodName)) continue;
            if (!CompileTimeObjectModel.isMethodAllowed(m)) break;
            return m;
        }
        return null;
    }

    private static boolean isMethodAllowed(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        return declaringClass != Object.class || TO_STRING_METHOD.equals(method.getName());
    }

    private static Method extractMethodInheritanceChain(Class type, Method m) {
        Class<?>[] iFaces;
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        for (Class<?> iFace : iFaces = type.getInterfaces()) {
            Method mp = CompileTimeObjectModel.getClassMethod(iFace, m);
            if (mp == null) continue;
            return mp;
        }
        return CompileTimeObjectModel.getClassMethod(type.getSuperclass(), m);
    }

    private static Method getClassMethod(Class<?> clazz, Method m) {
        try {
            Method mp = clazz.getMethod(m.getName(), m.getParameterTypes());
            mp = CompileTimeObjectModel.extractMethodInheritanceChain(mp.getDeclaringClass(), mp);
            if (mp != null) {
                return mp;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }
}

