/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class TestPlugin
extends AbstractPlugin {
    public TestPlugin() {
        this.name = "test";
        this.priority = 1;
    }

    @Override
    public PluginInvoke invoke(final Expression expressionNode, final PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private boolean globalBinding;

            @Override
            public void beforeElement(PushStream stream, String tagName) {
                String variableName = TestPlugin.this.decodeVariableName(callInfo);
                boolean bl = this.globalBinding = variableName != null;
                if (variableName == null) {
                    variableName = compilerContext.generateVariable("testVariable");
                }
                if (this.globalBinding) {
                    stream.write(new VariableBinding.Global(variableName, expressionNode.getRoot()));
                } else {
                    stream.write(new VariableBinding.Start(variableName, expressionNode.getRoot()));
                }
                stream.write(new Conditional.Start(variableName, true));
            }

            @Override
            public void afterElement(PushStream stream) {
                stream.write(Conditional.END);
                if (!this.globalBinding) {
                    stream.write(VariableBinding.END);
                }
            }
        };
    }
}

