/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.filter.AbstractFilter;

public final class I18nFilter
extends AbstractFilter {
    public static final String I18N_OPTION = "i18n";
    public static final String HINT_OPTION = "hint";
    public static final String LOCALE_OPTION = "locale";
    public static final String BASENAME_OPTION = "basename";

    private I18nFilter() {
        super(NON_PARAMETRIZABLE_CONTEXTS, new HashSet<String>(Arrays.asList(I18N_OPTION, HINT_OPTION, LOCALE_OPTION, BASENAME_OPTION)), Collections.singleton(I18N_OPTION));
        this.priority = 90;
    }

    public static I18nFilter getInstance() {
        return I18nFilterLoader.INSTANCE;
    }

    @Override
    protected Expression apply(Expression expression, Map<String, ExpressionNode> options) {
        RuntimeCall translation = new RuntimeCall(I18N_OPTION, expression.getRoot(), new MapLiteral(options));
        if (options.containsKey(LOCALE_OPTION)) {
            expression.getOptions().put(LOCALE_OPTION, options.get(LOCALE_OPTION));
        }
        return expression.withNode(translation);
    }

    private static final class I18nFilterLoader {
        private static final I18nFilter INSTANCE = new I18nFilter();

        private I18nFilterLoader() {
        }
    }
}

