/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.serviceusermapping.impl.Mapping;
import org.apache.sling.serviceusermapping.impl.ServiceUserMappedImpl;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;

@Component(immediate=true)
@Service(value={EventListenerHook.class, FindHook.class})
public class ServiceUserMappedBundleFilter
implements EventListenerHook,
FindHook {
    public void event(ServiceEvent serviceEvent, Map map) {
        Object serviceName;
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        if (ServiceUserMappedBundleFilter.isServiceMappingReference(serviceReference) && (serviceName = serviceReference.getProperty(Mapping.SERVICENAME)) != null && serviceName instanceof String) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                BundleContext ctx = (BundleContext)it.next().getKey();
                String bundleServiceName = ServiceUserMapperImpl.getServiceName(ctx.getBundle());
                if (serviceName.equals(bundleServiceName)) continue;
                it.remove();
            }
        }
    }

    public void find(BundleContext bundleContext, String name, String filter, boolean allServices, Collection references) {
        String bundleServiceName = ServiceUserMapperImpl.getServiceName(bundleContext.getBundle());
        Iterator it = references.iterator();
        while (it.hasNext()) {
            Object serviceName;
            ServiceReference serviceReference = (ServiceReference)it.next();
            if (!ServiceUserMappedBundleFilter.isServiceMappingReference(serviceReference) || (serviceName = serviceReference.getProperty(Mapping.SERVICENAME)) == null || serviceName.equals(bundleServiceName)) continue;
            it.remove();
        }
    }

    private static boolean isServiceMappingReference(ServiceReference serviceReference) {
        Object objectClass = serviceReference.getProperty("objectClass");
        for (Object o : (Object[])objectClass) {
            if (!ServiceUserMappedImpl.SERVICEUSERMAPPED.equals(o)) continue;
            return true;
        }
        return false;
    }
}

