/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceusermapping.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.serviceusermapping.Mapping;
import org.apache.sling.serviceusermapping.impl.ServiceUserMappedImpl;
import org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={EventListenerHook.class, FindHook.class})
public class ServiceUserMappedBundleFilter
implements EventListenerHook,
FindHook {
    @Reference
    volatile ServiceUserMapperImpl mapper;
    volatile BundleContext context;

    @Activate
    void start(BundleContext context) {
        this.context = context;
    }

    public void event(ServiceEvent serviceEvent, Map map) {
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        if (ServiceUserMappedBundleFilter.isServiceMappingReference(serviceReference) && serviceEvent.getType() == 1) {
            Object serviceName = serviceReference.getProperty(Mapping.SERVICENAME);
            String subserviceName = ServiceUserMappedBundleFilter.getSubServiceName(serviceReference);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                BundleContext ctx = (BundleContext)entry.getKey();
                if (ctx.getBundle().equals(this.context.getBundle()) || this.isValid(ctx.getBundle(), serviceName, subserviceName)) continue;
                boolean keep = false;
                Iterator iter = ((Collection)entry.getValue()).iterator();
                while (iter.hasNext()) {
                    if (!this.matchDefault(ctx.getBundle(), serviceName, subserviceName, ((ListenerHook.ListenerInfo)iter.next()).getFilter(), serviceReference)) {
                        iter.remove();
                        continue;
                    }
                    keep = true;
                }
                if (keep) continue;
                it.remove();
            }
        }
    }

    public void find(BundleContext bundleContext, String name, String filter, boolean allServices, Collection references) {
        Iterator it = references.iterator();
        while (it.hasNext()) {
            ServiceReference serviceReference = (ServiceReference)it.next();
            if (!ServiceUserMappedBundleFilter.isServiceMappingReference(serviceReference)) continue;
            Object serviceName = serviceReference.getProperty(Mapping.SERVICENAME);
            String subserviceName = ServiceUserMappedBundleFilter.getSubServiceName(serviceReference);
            if (this.isValid(bundleContext.getBundle(), serviceName, subserviceName) || this.matchDefault(bundleContext.getBundle(), serviceName, subserviceName, filter, serviceReference)) continue;
            it.remove();
        }
    }

    private boolean isValid(Bundle bundle, Object serviceName, String subserviceName) {
        String bundleServiceName = this.mapper.getServiceName(bundle);
        if (bundleServiceName.equals(serviceName)) {
            Iterable<String> principals = this.mapper.getServicePrincipalNames(bundle, subserviceName);
            if (principals != null && principals.iterator().hasNext()) {
                return true;
            }
            String user = this.mapper.getServiceUserID(bundle, subserviceName);
            if (user != null && !user.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean matchDefault(Bundle bundle, Object serviceName, String subserviceName, String filter, ServiceReference ref) {
        if (this.mapper.getServiceName(this.context.getBundle()).equals(serviceName)) {
            try {
                if (filter != null && this.context.createFilter(filter).match(ref)) {
                    for (Mapping mapping : this.mapper.getActiveMappings()) {
                        if (!mapping.getServiceName().equals(this.mapper.getServiceName(bundle))) continue;
                        return false;
                    }
                    Iterable<String> principals = this.mapper.getServicePrincipalNames(bundle, subserviceName);
                    if (principals != null && principals.iterator().hasNext()) {
                        return true;
                    }
                    String user = this.mapper.getServiceUserID(bundle, subserviceName);
                    if (user != null && !user.isEmpty()) {
                        return true;
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private static boolean isServiceMappingReference(ServiceReference serviceReference) {
        Object objectClass = serviceReference.getProperty("objectClass");
        for (Object o : (Object[])objectClass) {
            if (!ServiceUserMappedImpl.SERVICEUSERMAPPED.equals(o)) continue;
            return true;
        }
        return false;
    }

    private static String getSubServiceName(ServiceReference ref) {
        Object subserviceName = ref.getProperty("subServiceName");
        if (subserviceName != null && subserviceName instanceof String) {
            return (String)subserviceName;
        }
        return null;
    }
}

