/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

class HeaderSupport {
    private static final String RFC_1123_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final DateFormat RFC1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    private static final TimeZone TIMEZONE_GMT = TimeZone.getTimeZone("GMT");
    private List<HeaderValue> headers = new ArrayList<HeaderValue>();

    HeaderSupport() {
    }

    public void addHeader(String name, String value) {
        this.headers.add(new HeaderValue(name, value));
    }

    public void addIntHeader(String name, int value) {
        this.headers.add(new HeaderValue(name, Integer.toString(value)));
    }

    public void addDateHeader(String name, long date) {
        Calendar calendar = Calendar.getInstance(TIMEZONE_GMT, Locale.US);
        calendar.setTimeInMillis(date);
        this.headers.add(new HeaderValue(name, HeaderSupport.formatDate(calendar)));
    }

    public void setHeader(String name, String value) {
        this.removeHeaders(name);
        this.addHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.removeHeaders(name);
        this.addIntHeader(name, value);
    }

    public void setDateHeader(String name, long date) {
        this.removeHeaders(name);
        this.addDateHeader(name, date);
    }

    private void removeHeaders(String name) {
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            if (!StringUtils.equals((CharSequence)this.headers.get(i).getKey(), (CharSequence)name)) continue;
            this.headers.remove(i);
        }
    }

    public boolean containsHeader(String name) {
        return !this.getHeaders(name).isEmpty();
    }

    public String getHeader(String name) {
        Collection<String> values = this.getHeaders(name);
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return NumberUtils.toInt((String)value);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0L;
        }
        try {
            return HeaderSupport.parseDate(value).getTimeInMillis();
        }
        catch (ParseException ex) {
            return 0L;
        }
    }

    public Collection<String> getHeaders(String name) {
        ArrayList<String> values = new ArrayList<String>();
        for (HeaderValue entry : this.headers) {
            if (!StringUtils.equals((CharSequence)entry.getKey(), (CharSequence)name)) continue;
            values.add(entry.getValue());
        }
        return values;
    }

    public Collection<String> getHeaderNames() {
        HashSet<String> values = new HashSet<String>();
        for (HeaderValue entry : this.headers) {
            values.add(entry.getKey());
        }
        return values;
    }

    public void reset() {
        this.headers.clear();
    }

    public static Enumeration<String> toEnumeration(Collection<String> collection) {
        return new Vector<String>(collection).elements();
    }

    private static synchronized String formatDate(Calendar date) {
        return RFC1123_DATE_FORMAT.format(date.getTime());
    }

    private static synchronized Calendar parseDate(String dateString) throws ParseException {
        RFC1123_DATE_FORMAT.parse(dateString);
        return RFC1123_DATE_FORMAT.getCalendar();
    }

    static {
        RFC1123_DATE_FORMAT.setTimeZone(TIMEZONE_GMT);
    }

    private static class HeaderValue {
        private String key;
        private String value;

        public HeaderValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

