/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.servlets.get.impl.helpers.HtmlRendererServlet;
import org.apache.sling.servlets.get.impl.helpers.JsonRendererServlet;
import org.apache.sling.servlets.get.impl.helpers.PlainTextRendererServlet;
import org.apache.sling.servlets.get.impl.helpers.StreamRendererServlet;
import org.apache.sling.servlets.get.impl.helpers.XMLRendererServlet;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGetServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -5815904221043005085L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Map<String, Servlet> rendererMap = new HashMap<String, Servlet>();
    private Servlet streamerServlet;
    private static final String ALIAS_PROPERTY = "aliases";
    private static final boolean DEFAULT_INDEX_PROPERTY = false;
    private static final String INDEX_PROPERTY = "index";
    private static final String[] DEFAULT_INDEX_FILES_PROPERTY = new String[]{"index", "index.html"};
    private static final String INDEX_FILES_PROPERTY = "index.files";
    private static final boolean DEFAULT_RENDERER_PROPERTY = true;
    private static final String HTML_RENDERER_PROPERTY = "enable.html";
    private static final String TXT_RENDERER_PROPERTY = "enable.txt";
    private static final String JSON_RENDERER_PROPERTY = "enable.json";
    private static final String XML_RENDERER_PROPERTY = "enable.xml";
    public static final int DEFAULT_JSON_RENDERER_MAXIMUM_RESULTS = 200;
    public static final String JSON_RENDERER_MAXIMUM_RESULTS_PROPERTY = "json.maximumresults";
    private int jsonMaximumResults;
    private String[] aliases;
    private boolean index;
    private String[] indexFiles;
    private boolean enableHtml;
    private boolean enableTxt;
    private boolean enableJson;
    private boolean enableXml;

    protected void activate(ComponentContext ctx) {
        Dictionary props = ctx.getProperties();
        this.aliases = OsgiUtil.toStringArray(props.get(ALIAS_PROPERTY));
        this.index = OsgiUtil.toBoolean(props.get(INDEX_PROPERTY), (boolean)false);
        this.indexFiles = OsgiUtil.toStringArray(props.get(INDEX_FILES_PROPERTY), (String[])DEFAULT_INDEX_FILES_PROPERTY);
        this.enableHtml = OsgiUtil.toBoolean(props.get(HTML_RENDERER_PROPERTY), (boolean)true);
        this.enableTxt = OsgiUtil.toBoolean(props.get(TXT_RENDERER_PROPERTY), (boolean)true);
        this.enableJson = OsgiUtil.toBoolean(props.get(JSON_RENDERER_PROPERTY), (boolean)true);
        this.enableXml = OsgiUtil.toBoolean(props.get(XML_RENDERER_PROPERTY), (boolean)true);
        this.jsonMaximumResults = OsgiUtil.toInteger(props.get(JSON_RENDERER_MAXIMUM_RESULTS_PROPERTY), (int)200);
    }

    protected void deactivate(ComponentContext ctx) {
        this.aliases = null;
        this.index = false;
        this.indexFiles = null;
    }

    public void init() throws ServletException {
        super.init();
        this.setupServlet(this.rendererMap, "res", (Servlet)new StreamRendererServlet(this.index, this.indexFiles));
        if (this.enableHtml) {
            this.setupServlet(this.rendererMap, "html", (Servlet)new HtmlRendererServlet());
        }
        if (this.enableTxt) {
            this.setupServlet(this.rendererMap, "txt", (Servlet)new PlainTextRendererServlet());
        }
        if (this.enableJson) {
            this.setupServlet(this.rendererMap, "json", (Servlet)new JsonRendererServlet(this.jsonMaximumResults));
        }
        if (this.enableXml) {
            this.setupServlet(this.rendererMap, "xml", (Servlet)new XMLRendererServlet());
        }
        this.streamerServlet = this.rendererMap.get("res");
        if (this.aliases != null) {
            for (String m : this.aliases) {
                String type;
                Servlet servlet;
                int pos = m.indexOf(58);
                if (pos == -1 || (servlet = this.rendererMap.get(type = m.substring(0, pos))) == null) continue;
                String extensions = m.substring(pos + 1);
                StringTokenizer st = new StringTokenizer(extensions, ",");
                while (st.hasMoreTokens()) {
                    String ext = st.nextToken();
                    this.rendererMap.put(ext, servlet);
                }
            }
        }
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            throw new ResourceNotFoundException(request.getResource().getPath(), "No resource found");
        }
        String ext = request.getRequestPathInfo().getExtension();
        Servlet rendererServlet = ext == null ? this.streamerServlet : this.rendererMap.get(ext);
        if (rendererServlet == null) {
            request.getRequestProgressTracker().log("No renderer for extension " + ext);
            if (response.isCommitted() || request.getAttribute("org.apache.sling.api.include.servlet") != null) {
                this.logger.error("No renderer for extension {}, cannot render resource {}", (Object)ext, (Object)request.getResource());
            } else {
                response.sendError(404);
            }
            return;
        }
        request.getRequestProgressTracker().log("Using " + rendererServlet.getClass().getName() + " to render for extension=" + ext);
        rendererServlet.service((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        for (Servlet servlet : this.rendererMap.values()) {
            try {
                servlet.destroy();
            }
            catch (Throwable t) {
                this.logger.error("Error while destroying servlet " + servlet, t);
            }
        }
        this.streamerServlet = null;
        this.rendererMap.clear();
        super.destroy();
    }

    private void setupServlet(Map<String, Servlet> rendererMap, String key, Servlet servlet) {
        try {
            servlet.init(this.getServletConfig());
            rendererMap.put(key, servlet);
        }
        catch (Throwable t) {
            this.logger.error("Error while initializing servlet " + servlet, t);
        }
    }
}

