/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHeadServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 7416222678552027044L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doHead(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (response.isCommitted()) {
            this.log.warn("DefaultHeadServlet: Ignoring request because response is committed");
            request.getRequestProgressTracker().log("DefaultHeadServlet: Ignoring request because response is committed");
            return;
        }
        if (request.getAttribute("org.apache.sling.api.include.servlet") != null) {
            this.log.warn("DefaultHeadServlet: Ignoring request because request is included");
            request.getRequestProgressTracker().log("DefaultHeadServlet: Ignoring request because request is included");
            return;
        }
        request = new HeadServletRequest((SlingHttpServletRequest)request);
        response = new HeadServletResponse((SlingHttpServletResponse)response);
        RequestDispatcher dispatcher = request.getRequestDispatcher(request.getResource());
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void write(char[] cbuf, int off, int len) {
        }

        public void write(char[] cbuf) {
        }

        public void write(int c) {
        }

        public void write(String str) {
        }

        public void write(String str, int off, int len) {
        }

        public void flush() {
        }

        public void close() {
        }
    }

    private static class NullServletOutputStream
    extends ServletOutputStream {
        private NullServletOutputStream() {
        }

        public void write(int b) {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }
    }

    private static class HeadServletResponse
    extends SlingHttpServletResponseWrapper {
        private ServletOutputStream stream;
        private PrintWriter writer;

        public HeadServletResponse(SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
        }

        public ServletOutputStream getOutputStream() {
            if (this.writer != null) {
                throw new IllegalStateException("Writer already obtained");
            }
            if (this.stream == null) {
                this.stream = new NullServletOutputStream();
            }
            return this.stream;
        }

        public PrintWriter getWriter() {
            if (this.stream != null) {
                throw new IllegalStateException("OutputStream already obtained");
            }
            if (this.writer == null) {
                this.writer = new PrintWriter(new NullWriter());
            }
            return this.writer;
        }
    }

    private static class HeadServletRequest
    extends SlingHttpServletRequestWrapper {
        public HeadServletRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

