/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl;

import java.io.IOException;
import java.util.Dictionary;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.servlets.get.impl.helpers.JsonRendererServlet;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectServlet
extends SlingSafeMethodsServlet {
    public static final String TARGET_PROP = "sling:target";
    public static final String STATUS_PROP = "sling:status";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Servlet jsonRendererServlet;
    public static final int DEFAULT_JSON_RENDERER_MAXIMUM_RESULTS = 200;
    public static final String JSON_RENDERER_MAXIMUM_RESULTS_PROPERTY = "json.maximumresults";
    private int jsonMaximumResults;

    protected void activate(ComponentContext ctx) {
        Dictionary props = ctx.getProperties();
        this.jsonMaximumResults = OsgiUtil.toInteger(props.get(JSON_RENDERER_MAXIMUM_RESULTS_PROPERTY), (int)200);
        this.jsonRendererServlet = this.getJsonRendererServlet();
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if ("json".equals(request.getRequestPathInfo().getExtension())) {
            this.getJsonRendererServlet().service((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (response.isCommitted()) {
            this.log.warn("RedirectServlet: Response is already committed, not redirecting");
            request.getRequestProgressTracker().log("RedirectServlet: Response is already committed, not redirecting");
            return;
        }
        if (request.getAttribute("org.apache.sling.api.include.servlet") != null) {
            this.log.warn("RedirectServlet: Servlet is included, not redirecting");
            request.getRequestProgressTracker().log("RedirectServlet: Servlet is included, not redirecting");
            return;
        }
        String targetPath = null;
        Resource rsrc = request.getResource();
        ValueMap valueMap = (ValueMap)rsrc.adaptTo(ValueMap.class);
        if (valueMap != null) {
            targetPath = (String)valueMap.get(TARGET_PROP, String.class);
        }
        if (targetPath == null) {
            Resource targetResource = request.getResourceResolver().getResource(rsrc, TARGET_PROP);
            if (targetResource == null) {
                response.sendError(404, "Missing target for redirection");
                return;
            }
            targetPath = (String)targetResource.adaptTo(String.class);
        }
        if (targetPath != null) {
            targetPath = !RedirectServlet.isUrl(targetPath) ? RedirectServlet.toRedirectPath(targetPath, request) : RedirectServlet.appendSelectorsExtensionSuffixQuery(request, new StringBuilder(targetPath)).toString();
            int status = RedirectServlet.getStatus(valueMap);
            response.reset();
            response.setStatus(status);
            response.setHeader("Location", targetPath);
            response.flushBuffer();
            return;
        }
        response.sendError(404, "Cannot redirect to target resource " + targetPath);
    }

    static int getStatus(ValueMap valueMap) {
        int status;
        Integer statusInt;
        if (valueMap != null && (statusInt = (Integer)valueMap.get(STATUS_PROP, Integer.class)) != null && (status = statusInt.intValue()) >= 100 && status <= 999) {
            return status;
        }
        return 302;
    }

    static String toRedirectPath(String targetPath, SlingHttpServletRequest request) {
        String rawAbsPath = targetPath.startsWith("/") ? targetPath : request.getResource().getPath() + "/" + targetPath;
        StringBuilder target = new StringBuilder();
        String absPath = ResourceUtil.normalize((String)rawAbsPath);
        if (absPath == null) {
            target.append(rawAbsPath);
        } else {
            target.append(absPath);
        }
        RedirectServlet.appendSelectorsExtensionSuffixQuery(request, target);
        return request.getResourceResolver().map((HttpServletRequest)request, target.toString());
    }

    private static StringBuilder appendSelectorsExtensionSuffixQuery(SlingHttpServletRequest request, StringBuilder target) {
        RequestPathInfo rpi = request.getRequestPathInfo();
        if (rpi.getExtension() != null) {
            if (rpi.getSelectorString() != null) {
                target.append('.').append(rpi.getSelectorString());
            }
            target.append('.').append(rpi.getExtension());
            if (rpi.getSuffix() != null) {
                target.append(rpi.getSuffix());
            }
        }
        if (request.getQueryString() != null) {
            target.append('?').append(request.getQueryString());
        }
        return target;
    }

    static String toAbsoluteUri(String scheme, String host, int port, String targetPath) {
        StringBuilder absUriBuilder = new StringBuilder();
        absUriBuilder.append(scheme).append("://").append(host);
        if (!(port <= 0 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            absUriBuilder.append(':').append(port);
        }
        absUriBuilder.append(targetPath);
        return absUriBuilder.toString();
    }

    private Servlet getJsonRendererServlet() {
        if (this.jsonRendererServlet == null) {
            JsonRendererServlet jrs = new JsonRendererServlet(this.jsonMaximumResults);
            try {
                jrs.init(this.getServletConfig());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.jsonRendererServlet = jrs;
        }
        return this.jsonRendererServlet;
    }

    private static boolean isUrl(String path) {
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ':') {
                return true;
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || i > 0 && (c >= '0' && c <= '9' || c == '.' || c == '+' || c == '-'))) break;
        }
        return false;
    }
}

