/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

public class HtmlRendererServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -5815904221043005085L;
    public static final String EXT_HTML = "html";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        Resource r = req.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)r)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();
        boolean isIncluded = req.getAttribute("org.apache.sling.api.include.servlet") != null;
        Map map = (Map)r.adaptTo(Map.class);
        if (map != null) {
            this.printProlog(pw, isIncluded);
            this.printResourceInfo(pw, r);
            this.render(pw, r, map);
            this.printEpilog(pw, isIncluded);
        } else if (r.adaptTo(String.class) != null) {
            this.printProlog(pw, isIncluded);
            this.printResourceInfo(pw, r);
            this.render(pw, r, (String)r.adaptTo(String.class));
            this.printEpilog(pw, isIncluded);
        } else if (r.adaptTo(String[].class) != null) {
            this.printProlog(pw, isIncluded);
            this.printResourceInfo(pw, r);
            this.render(pw, r, (String[])r.adaptTo(String[].class));
            this.printEpilog(pw, isIncluded);
        } else if (!isIncluded) {
            resp.sendError(204);
        }
    }

    private void printProlog(PrintWriter pw, boolean isIncluded) {
        if (!isIncluded) {
            pw.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"");
            pw.println("    \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
            pw.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">");
            pw.println("<head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" /></head>");
            pw.println("<body>");
        }
    }

    private void printEpilog(PrintWriter pw, boolean isIncluded) {
        if (!isIncluded) {
            pw.println("</body></html>");
        }
    }

    private void printResourceInfo(PrintWriter pw, Resource r) {
        pw.println("<h1>Resource dumped by " + ((Object)((Object)this)).getClass().getSimpleName() + "</h1>");
        pw.println("<p>Resource path: <b>" + r.getPath() + "</b></p>");
        pw.println("<p>Resource metadata: <b>" + StringEscapeUtils.escapeHtml((String)String.valueOf(r.getResourceMetadata())) + "</b></p>");
        pw.println("<p>Resource type: <b>" + r.getResourceType() + "</b></p>");
        String resourceSuperType = ResourceUtil.findResourceSuperType((Resource)r);
        if (resourceSuperType == null) {
            resourceSuperType = "-";
        }
        pw.println("<p>Resource super type: <b>" + resourceSuperType + "</b></p>");
    }

    private void render(PrintWriter pw, Resource r, Map map) {
        pw.println("<h2>Resource properties</h2>");
        pw.println("<p>");
        for (Map.Entry p : map.entrySet()) {
            this.printPropertyValue(pw, p.getKey().toString(), p.getValue());
            pw.println();
        }
        pw.println("</p>");
    }

    private void render(PrintWriter pw, Resource r, String value) {
        this.printPropertyValue(pw, "Resource Value", value);
    }

    private void render(PrintWriter pw, Resource r, String[] values) {
        for (String value : values) {
            this.printPropertyValue(pw, "Resource Value", value);
        }
    }

    private void printPropertyValue(PrintWriter pw, String name, Object value) {
        pw.print(name + ": <b>");
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            pw.print('[');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(values[i].toString());
            }
            pw.print(']');
        } else {
            pw.print(value.toString());
        }
        pw.print("</b><br />");
    }
}

