/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public abstract class JsonObjectCreator {
    private static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    private static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private static final DateFormat CALENDAR_FORMAT = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z", DATE_FORMAT_LOCALE);

    public static JSONObject create(Resource resource, int maxRecursionLevels) throws JSONException {
        return JsonObjectCreator.create(resource, 0, maxRecursionLevels);
    }

    private static JSONObject create(Resource resource, int currentRecursionLevel, int maxRecursionLevels) throws JSONException {
        JSONObject obj;
        block5: {
            ValueMap propertyMap;
            ValueMap valueMap;
            block3: {
                block4: {
                    valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
                    propertyMap = valueMap != null ? valueMap : (Map)resource.adaptTo(Map.class);
                    obj = new JSONObject();
                    if (propertyMap != null) break block3;
                    String value = (String)resource.adaptTo(String.class);
                    if (value == null) break block4;
                    obj.put(ResourceUtil.getName((Resource)resource), (Object)value);
                    break block5;
                }
                String[] values = (String[])resource.adaptTo(String[].class);
                if (values == null) break block5;
                obj.put(ResourceUtil.getName((Resource)resource), (Object)new JSONArray(Arrays.asList(values)));
                break block5;
            }
            for (Map.Entry prop : propertyMap.entrySet()) {
                JsonObjectCreator.createProperty(obj, valueMap, prop.getKey().toString(), prop.getValue());
            }
        }
        if (JsonObjectCreator.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            Iterator children = ResourceUtil.listChildren((Resource)resource);
            while (children.hasNext()) {
                Resource n = (Resource)children.next();
                JsonObjectCreator.createSingleResource(n, obj, currentRecursionLevel, maxRecursionLevels);
            }
        }
        return obj;
    }

    private static synchronized String format(Calendar date) {
        return CALENDAR_FORMAT.format(date.getTime());
    }

    private static Object getValue(Object value) {
        if (value instanceof InputStream) {
            return 0;
        }
        if (value instanceof Calendar) {
            return JsonObjectCreator.format((Calendar)value);
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Long) {
            return value;
        }
        if (value instanceof Integer) {
            return value;
        }
        if (value instanceof Double) {
            return value;
        }
        return value.toString();
    }

    private static void createSingleResource(Resource n, JSONObject parent, int currentRecursionLevel, int maxRecursionLevels) throws JSONException {
        if (JsonObjectCreator.recursionLevelActive(currentRecursionLevel, maxRecursionLevels)) {
            parent.put(ResourceUtil.getName((Resource)n), (Object)JsonObjectCreator.create(n, currentRecursionLevel + 1, maxRecursionLevels));
        }
    }

    private static boolean recursionLevelActive(int currentRecursionLevel, int maxRecursionLevels) {
        return maxRecursionLevels < 0 || currentRecursionLevel < maxRecursionLevels;
    }

    private static void createProperty(JSONObject obj, ValueMap valueMap, String key, Object value) throws JSONException {
        Object[] values = null;
        if (value.getClass().isArray() && (values = (Object[])value).length == 0) {
            obj.put(key, (Object)new JSONArray());
            return;
        }
        if (value instanceof InputStream || values != null && values[0] instanceof InputStream) {
            if (values == null) {
                obj.put(":" + key, JsonObjectCreator.getLength(valueMap, -1, key, (InputStream)value));
            } else {
                JSONArray result = new JSONArray();
                for (int i = 0; i < values.length; ++i) {
                    result.put(JsonObjectCreator.getLength(valueMap, i, key, (InputStream)values[i]));
                }
                obj.put(":" + key, (Object)result);
            }
            return;
        }
        if (!value.getClass().isArray()) {
            obj.put(key, JsonObjectCreator.getValue(value));
        } else {
            JSONArray result = new JSONArray();
            for (Object v : values) {
                result.put(JsonObjectCreator.getValue(v));
            }
            obj.put(key, (Object)result);
        }
    }

    private static long getLength(ValueMap valueMap, int index, String key, InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        long length = -1L;
        if (valueMap != null) {
            if (index == -1) {
                length = (Long)valueMap.get(key, (Object)length);
            } else {
                Long[] lengths = (Long[])valueMap.get(key, Long[].class);
                if (lengths != null && lengths.length > index) {
                    length = lengths[index];
                }
            }
        }
        return length;
    }
}

