/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.servlets.get.impl.helpers.ResourceTraversor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRendererServlet
extends SlingSafeMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(JsonRendererServlet.class);
    private static final long serialVersionUID = 5577121546674133317L;
    public static final String EXT_JSON = "json";
    public static final String INFINITY = "infinity";
    public static final String TIDY = "tidy";
    private long maximumResults;

    public JsonRendererServlet(long maximumResults) {
        this.maximumResults = maximumResults;
    }

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws IOException {
        String level;
        Resource r = req.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)r)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        int maxRecursionLevels = 0;
        String[] selectors = req.getRequestPathInfo().getSelectors();
        if (selectors != null && selectors.length > 0 && !TIDY.equals(level = selectors[selectors.length - 1])) {
            if (INFINITY.equals(level)) {
                maxRecursionLevels = -1;
            } else {
                try {
                    maxRecursionLevels = Integer.parseInt(level);
                }
                catch (NumberFormatException nfe) {
                    if (StringUtils.isNumeric((String)level)) {
                        maxRecursionLevels = -1;
                    }
                    resp.sendError(400, "Invalid recursion selector value '" + level + "'");
                    return;
                }
            }
        }
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        boolean allowDump = true;
        int allowedLevel = 0;
        boolean tidy = this.isTidy(req);
        ResourceTraversor traversor = null;
        try {
            traversor = new ResourceTraversor(maxRecursionLevels, this.maximumResults, r, tidy);
            allowedLevel = traversor.collectResources();
            if (allowedLevel != -1) {
                allowDump = false;
            }
        }
        catch (JSONException e) {
            this.reportException((Exception)((Object)e));
        }
        try {
            if (allowDump) {
                if (tidy) {
                    resp.getWriter().write(traversor.getJSONObject().toString(2));
                } else {
                    resp.getWriter().write(traversor.getJSONObject().toString());
                }
            } else {
                String tidyUrl = tidy ? "tidy." : "";
                resp.setStatus(300);
                JSONWriter writer = new JSONWriter((Writer)resp.getWriter());
                writer.array();
                while (allowedLevel >= 0) {
                    writer.value((Object)(r.getResourceMetadata().getResolutionPath() + "." + tidyUrl + allowedLevel + ".json"));
                    --allowedLevel;
                }
                writer.endArray();
            }
        }
        catch (JSONException je) {
            this.reportException((Exception)((Object)je));
        }
    }

    protected boolean isTidy(SlingHttpServletRequest req) {
        for (String selector : req.getRequestPathInfo().getSelectors()) {
            if (!TIDY.equals(selector)) continue;
            return true;
        }
        return false;
    }

    private void reportException(Exception e) {
        this.log.warn("Error in JsonRendererServlet: " + e.toString(), (Throwable)e);
        throw new SlingException(e.toString(), (Throwable)e);
    }
}

