/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

public class PlainTextRendererServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -5815904221043005085L;
    public static final String EXT_TXT = "txt";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        Resource r = req.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)r)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();
        Map map = (Map)r.adaptTo(Map.class);
        if (map != null) {
            this.dump(pw, r, map);
        } else if (r.adaptTo(String.class) != null) {
            this.printPropertyValue(pw, ResourceUtil.getName((Resource)r), r.adaptTo(String.class), false);
        } else if (r.adaptTo(String[].class) != null) {
            this.printPropertyValue(pw, ResourceUtil.getName((Resource)r), r.adaptTo(String[].class), false);
        } else {
            resp.sendError(204);
        }
    }

    protected void dump(PrintWriter pw, Resource r, Map map) {
        pw.println("** Resource dumped by " + ((Object)((Object)this)).getClass().getSimpleName() + "**");
        pw.println("Resource path:" + r.getPath());
        pw.println("Resource metadata: " + r.getResourceMetadata());
        pw.println("Resource type: " + r.getResourceType());
        String resourceSuperType = ResourceUtil.findResourceSuperType((Resource)r);
        if (resourceSuperType == null) {
            resourceSuperType = "-";
        }
        pw.println("Resource super type: " + resourceSuperType);
        pw.println("\n** Resource properties **");
        for (Map.Entry p : map.entrySet()) {
            this.printPropertyValue(pw, p.getKey().toString(), p.getValue(), true);
            pw.println();
        }
    }

    protected void printPropertyValue(PrintWriter pw, String name, Object value, boolean includeName) {
        if (includeName) {
            pw.print(name + ": ");
        }
        if (value.getClass().isArray()) {
            Object[] values = (Object[])value;
            pw.print('[');
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(values[i].toString());
            }
            pw.print(']');
        } else {
            pw.print(value.toString());
        }
    }
}

