/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamRendererServlet
extends SlingSafeMethodsServlet {
    public static final String EXT_RES = "res";
    private static final long serialVersionUID = -1L;
    private static final String mimeSeparation = "SLING_MIME_BOUNDARY";
    private static ArrayList<Range> FULL = new ArrayList(0);
    private static final int IO_BUFFER_SIZE = 2048;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean index;
    private String[] indexFiles;

    public StreamRendererServlet(boolean index, String[] indexFiles) {
        this.index = index;
        this.indexFiles = indexFiles;
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceMetadata meta;
        long modifTime;
        boolean included = request.getAttribute("org.apache.sling.api.include.servlet") != null;
        String ext = request.getRequestPathInfo().getExtension();
        if (ext != null && !ext.equals(EXT_RES)) {
            request.getRequestProgressTracker().log("StreamRendererServlet does not support for extension " + ext);
            if (included || response.isCommitted()) {
                this.log.error("StreamRendererServlet does not support for extension {}", (Object)ext);
            } else {
                response.sendError(404);
            }
            return;
        }
        Resource resource = request.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        if ("/".equals(request.getRequestPathInfo().getSuffix())) {
            this.renderDirectory(request, response, included);
            return;
        }
        if (!included && this.unmodified((HttpServletRequest)request, modifTime = (meta = resource.getResourceMetadata()).getModificationTime())) {
            response.setStatus(304);
            return;
        }
        InputStream stream = (InputStream)resource.adaptTo(InputStream.class);
        if (stream != null) {
            this.streamResource(resource, stream, included, request, response);
        } else if (this.isRootResourceRequest(resource)) {
            this.renderDirectory(request, response, included);
        } else if (included || response.isCommitted()) {
            request.getRequestProgressTracker().log("StreamRendererServlet: Not redirecting with trailing slash, response is committed or request included");
            this.log.warn("StreamRendererServlet: Not redirecting with trailing slash, response is committed or request included");
        } else {
            String url = request.getResourceResolver().map((HttpServletRequest)request, resource.getPath()) + "/";
            response.sendRedirect(url);
        }
    }

    private boolean isRootResourceRequest(Resource resource) {
        return "/".equals(resource.getPath()) || "/".equals(resource.getResourceResolver().map(resource.getPath()));
    }

    private boolean unmodified(HttpServletRequest request, long modifTime) {
        if (modifTime > 0L) {
            long modTime = modifTime / 1000L;
            long ims = request.getDateHeader("If-Modified-Since") / 1000L;
            return modTime <= ims;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamResource(Resource resource, InputStream stream, boolean included, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        try {
            ArrayList<Range> ranges;
            if (included) {
                ranges = FULL;
            } else {
                ranges = this.parseRange((HttpServletRequest)request, (HttpServletResponse)response, resource.getResourceMetadata());
                if (ranges == null) {
                    return;
                }
                this.setHeaders(resource, response);
            }
            ServletOutputStream out = response.getOutputStream();
            if (ranges == FULL) {
                int rd;
                this.setContentLength((HttpServletResponse)response, resource.getResourceMetadata().getContentLength());
                byte[] buf = new byte[2048];
                while ((rd = stream.read(buf)) >= 0) {
                    out.write(buf, 0, rd);
                }
            } else {
                response.setStatus(206);
                if (ranges.size() == 1) {
                    Range range = ranges.get(0);
                    response.addHeader("Content-Range", "bytes " + range.start + "-" + range.end + "/" + range.length);
                    this.setContentLength((HttpServletResponse)response, range.end - range.start + 1L);
                    this.copy(stream, (OutputStream)out, range);
                } else {
                    response.setContentType("multipart/byteranges; boundary=SLING_MIME_BOUNDARY");
                    this.copy(resource, out, ranges.iterator());
                }
            }
        }
        finally {
            this.closeSilently(stream);
        }
    }

    private void renderDirectory(SlingHttpServletRequest request, SlingHttpServletResponse response, boolean included) throws ServletException, IOException {
        if (included || response.isCommitted()) {
            request.getRequestProgressTracker().log("StreamRendererServlet: Not rendering index, response is committed or request included");
            this.log.warn("StreamRendererServlet: Not rendering index, response is committed or request included");
            return;
        }
        Resource resource = request.getResource();
        ResourceResolver resolver = request.getResourceResolver();
        for (String index : this.indexFiles) {
            RequestDispatcher dispatcher;
            Resource fileRes = resolver.getResource(resource, index);
            if (fileRes == null || ResourceUtil.isSyntheticResource((Resource)fileRes)) continue;
            RequestDispatcherOptions rdo = new RequestDispatcherOptions();
            rdo.setReplaceSuffix("");
            rdo.setReplaceSelectors("");
            if (index.indexOf(46) < 0) {
                String filePath = fileRes.getPath() + ".html";
                dispatcher = request.getRequestDispatcher(filePath, rdo);
            } else {
                dispatcher = request.getRequestDispatcher(fileRes, rdo);
            }
            this.setHeaders(fileRes, response);
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.index) {
            this.renderIndex(resource, response);
        } else {
            response.sendError(403);
        }
    }

    private void setHeaders(Resource resource, SlingHttpServletResponse response) {
        String encoding;
        String ct;
        ResourceMetadata meta = resource.getResourceMetadata();
        long modifTime = meta.getModificationTime();
        if (modifTime > 0L) {
            response.setDateHeader("Last-Modified", modifTime);
        }
        String defaultContentType = "application/octet-stream";
        String contentType = meta.getContentType();
        if ((contentType == null || "application/octet-stream".equals(contentType)) && (ct = this.getServletContext().getMimeType(resource.getPath())) != null) {
            contentType = ct;
        }
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if ((encoding = meta.getCharacterEncoding()) != null) {
            response.setCharacterEncoding(encoding);
        }
    }

    private void setContentLength(HttpServletResponse response, long length) {
        if (length > 0L) {
            if (length < Integer.MAX_VALUE) {
                response.setContentLength((int)length);
            } else {
                response.setHeader("Content-Length", String.valueOf(length));
            }
        }
    }

    private void renderIndex(Resource resource, SlingHttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        String path = resource.getPath();
        PrintWriter pw = response.getWriter();
        pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>Index of " + path + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Index of " + path + "</h1>");
        pw.println("<pre>");
        pw.println("Name                               Last modified                   Size  Description");
        pw.println("<hr>");
        if (!"/".equals(path)) {
            pw.println("<a href='../'>../</a>                                                                 -     Parent");
        }
        Iterator children = ResourceUtil.listChildren((Resource)resource);
        while (children.hasNext()) {
            this.renderChild(pw, (Resource)children.next());
        }
        pw.println("</pre>");
        pw.println("</body>");
        pw.println("</html>");
    }

    private void renderChild(PrintWriter pw, Resource resource) {
        String suffix;
        String name = ResourceUtil.getName((String)resource.getPath());
        InputStream ins = (InputStream)resource.adaptTo(InputStream.class);
        if (ins == null) {
            name = name + "/";
        } else {
            this.closeSilently(ins);
        }
        String displayName = name;
        if (displayName.length() >= 32) {
            displayName = displayName.substring(0, 29) + "...";
            suffix = "";
        } else {
            suffix = "                                               ".substring(0, 32 - displayName.length());
        }
        pw.printf("<a href='%s'>%s</a>%s", name, displayName, suffix);
        ResourceMetadata meta = resource.getResourceMetadata();
        long lastModified = meta.getModificationTime();
        pw.print("    " + new Date(lastModified) + "    ");
        long length = meta.getContentLength();
        if (length > 0L) {
            pw.print(length);
        } else {
            pw.print('-');
        }
        pw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Resource resource, ServletOutputStream ostream, Iterator<Range> ranges) throws IOException {
        String contentType = resource.getResourceMetadata().getContentType();
        IOException exception = null;
        while (exception == null && ranges.hasNext()) {
            InputStream resourceInputStream = (InputStream)resource.adaptTo(InputStream.class);
            BufferedInputStream istream = new BufferedInputStream(resourceInputStream, 2048);
            try {
                Range currentRange = ranges.next();
                ostream.println();
                ostream.println("--SLING_MIME_BOUNDARY");
                if (contentType != null) {
                    ostream.println("Content-Type: " + contentType);
                }
                ostream.println("Content-Range: bytes " + currentRange.start + "-" + currentRange.end + "/" + currentRange.length);
                ostream.println();
                exception = this.copyRange(istream, (OutputStream)ostream, currentRange.start, currentRange.end);
            }
            finally {
                this.closeSilently(istream);
            }
        }
        ostream.println();
        ostream.print("--SLING_MIME_BOUNDARY--");
        if (exception != null) {
            throw exception;
        }
    }

    private void copy(InputStream resourceInputStream, OutputStream ostream, Range range) throws IOException {
        BufferedInputStream istream = new BufferedInputStream(resourceInputStream, 2048);
        IOException exception = this.copyRange(istream, ostream, range.start, range.end);
        if (exception != null) {
            throw exception;
        }
    }

    private IOException copyRange(InputStream istream, OutputStream ostream, long start, long end) {
        this.log.debug("copyRange: Serving bytes: {}-{}", (Object)start, (Object)end);
        try {
            long skipped = istream.skip(start);
            if (skipped < start) {
                return new IOException("Failed to skip " + start + " bytes; only skipped " + skipped + " bytes");
            }
        }
        catch (IOException e) {
            return e;
        }
        IOException exception = null;
        long bytesToRead = end - start + 1L;
        byte[] buffer = new byte[2048];
        int len = buffer.length;
        while (bytesToRead > 0L && len >= buffer.length) {
            try {
                len = istream.read(buffer);
                if (bytesToRead >= (long)len) {
                    ostream.write(buffer, 0, len);
                    bytesToRead -= (long)len;
                } else {
                    ostream.write(buffer, 0, (int)bytesToRead);
                    bytesToRead = 0L;
                }
            }
            catch (IOException e) {
                exception = e;
                len = -1;
            }
            if (len >= buffer.length) continue;
            break;
        }
        return exception;
    }

    private ArrayList<Range> parseRange(HttpServletRequest request, HttpServletResponse response, ResourceMetadata metadata) throws IOException {
        long fileLength;
        String headerValue = request.getHeader("If-Range");
        if (headerValue != null) {
            long headerValueTime = -1L;
            try {
                headerValueTime = request.getDateHeader("If-Range");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (headerValueTime == -1L) {
                return FULL;
            }
            if (metadata.getModificationTime() > headerValueTime + 1000L) {
                return FULL;
            }
        }
        if ((fileLength = metadata.getContentLength()) == 0L) {
            return FULL;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return FULL;
        }
        if (!rangeHeader.startsWith("bytes")) {
            this.failParseRange(response, fileLength, rangeHeader);
            return null;
        }
        rangeHeader = rangeHeader.substring(6);
        ArrayList<Range> result = new ArrayList<Range>();
        StringTokenizer commaTokenizer = new StringTokenizer(rangeHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String rangeDefinition = commaTokenizer.nextToken().trim();
            Range currentRange = new Range();
            currentRange.length = fileLength;
            int dashPos = rangeDefinition.indexOf(45);
            if (dashPos == -1) {
                this.failParseRange(response, fileLength, rangeHeader);
                return null;
            }
            if (dashPos == 0) {
                try {
                    long offset = Long.parseLong(rangeDefinition);
                    currentRange.start = fileLength + offset;
                    currentRange.end = fileLength - 1L;
                }
                catch (NumberFormatException e) {
                    this.failParseRange(response, fileLength, rangeHeader);
                    return null;
                }
            }
            try {
                currentRange.start = Long.parseLong(rangeDefinition.substring(0, dashPos));
                currentRange.end = dashPos < rangeDefinition.length() - 1 ? Long.parseLong(rangeDefinition.substring(dashPos + 1, rangeDefinition.length())) : fileLength - 1L;
            }
            catch (NumberFormatException e) {
                this.failParseRange(response, fileLength, rangeHeader);
                return null;
            }
            if (!currentRange.validate()) {
                this.failParseRange(response, fileLength, rangeHeader);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    private void failParseRange(HttpServletResponse response, long fileLength, String rangeHeader) throws IOException {
        this.log.error("parseRange: Cannot support range {}; sending 416", (Object)rangeHeader);
        response.addHeader("Content-Range", "bytes */" + fileLength);
        response.sendError(416);
    }

    private void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }
    }
}

