/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.helpers;

import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLRendererServlet
extends SlingSafeMethodsServlet {
    public static final String EXT_XML = "xml";
    private static final String SYSVIEW = "sysview";
    private static final String DOCVIEW = "docview";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp) throws ServletException, IOException {
        Resource r = req.getResource();
        if (ResourceUtil.isNonExistingResource((Resource)r)) {
            throw new ResourceNotFoundException("No data to render.");
        }
        resp.setContentType(req.getResponseContentType());
        resp.setCharacterEncoding("UTF-8");
        boolean isIncluded = req.getAttribute("org.apache.sling.api.include.servlet") != null;
        Node node = (Node)r.adaptTo(Node.class);
        if (node != null) {
            try {
                if (req.getRequestPathInfo().getSelectorString() == null || req.getRequestPathInfo().getSelectorString().equals(DOCVIEW)) {
                    ContentHandler ch = (ContentHandler)resp.adaptTo(ContentHandler.class);
                    if (ch == null) {
                        node.getSession().exportDocumentView(node.getPath(), (OutputStream)resp.getOutputStream(), false, false);
                    }
                    node.getSession().exportDocumentView(node.getPath(), ch, false, false);
                }
                if (req.getRequestPathInfo().getSelectorString().equals(SYSVIEW)) {
                    ContentHandler ch = (ContentHandler)resp.adaptTo(ContentHandler.class);
                    if (ch == null) {
                        node.getSession().exportSystemView(node.getPath(), (OutputStream)resp.getOutputStream(), false, false);
                    }
                    node.getSession().exportSystemView(node.getPath(), ch, false, false);
                }
                resp.sendError(204);
            }
            catch (RepositoryException e) {
                throw new ServletException("Unable to export resource as xml: " + r, (Throwable)e);
            }
            catch (SAXException e) {
                throw new ServletException("Unable to export resource as xml: " + r, (Throwable)e);
            }
        } else if (!isIncluded) {
            resp.sendError(204);
        }
    }
}

