/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.impl.info;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.servlets.get.impl.impl.info.SessionInfoProvider;
import org.apache.sling.servlets.get.impl.impl.info.SlingInfoProvider;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingInfoServlet
extends SlingSafeMethodsServlet {
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CACHE_CONTROL_HEADER_VALUE = "private, no-store, no-cache, max-age=0, must-revalidate";
    private Map<String, SlingInfoProvider> infoProviders = new HashMap<String, SlingInfoProvider>();

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String label;
        SlingInfoProvider uip;
        Map<String, String> data = null;
        if (request.getRequestPathInfo().getSelectors().length > 0 && (uip = this.infoProviders.get(label = request.getRequestPathInfo().getSelectors()[0])) != null) {
            data = uip.getInfo(request);
        }
        if (data == null) {
            response.sendError(404, "Unknown Info Request");
        } else {
            response.setHeader(CACHE_CONTROL_HEADER, CACHE_CONTROL_HEADER_VALUE);
            String extension = request.getRequestPathInfo().getExtension();
            if ("json".equals(extension)) {
                this.renderJson(response, data);
            } else if ("txt".equals(extension)) {
                this.renderPlainText(response, data);
            } else {
                this.renderHtml(response, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderJson(SlingHttpServletResponse response, Map<String, String> data) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        JSONWriter w = new JSONWriter((Writer)out);
        try {
            w.object();
            for (Map.Entry<String, String> e : data.entrySet()) {
                w.key(e.getKey());
                w.value((Object)e.getValue());
            }
            w.endObject();
        }
        catch (JSONException jse) {
            ((Writer)out).write(jse.toString());
        }
        finally {
            ((Writer)out).flush();
        }
    }

    private void renderHtml(SlingHttpServletResponse response, Map<String, String> data) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        out.println("<html><head><title>Sling Info</title></head>");
        out.println("<body><h1>Sling Info</h1>");
        out.println("<table>");
        for (Map.Entry<String, String> e : data.entrySet()) {
            out.print("<tr><td>");
            out.print(e.getKey());
            out.print("</td><td>");
            out.print(e.getValue());
            out.println("</td></tr>");
        }
        out.println("</table>");
        out.println("</body>");
        out.flush();
    }

    private void renderPlainText(SlingHttpServletResponse response, Map<String, String> data) throws IOException {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        for (Map.Entry<String, String> e : data.entrySet()) {
            out.print(e.getKey());
            out.print(": ");
            out.println(e.getValue());
        }
        out.flush();
    }

    protected void activate(ComponentContext context) {
        this.infoProviders.put("sessionInfo", new SessionInfoProvider());
    }
}

