/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.scripting.SlingScript;
import org.apache.sling.api.scripting.SlingScriptResolver;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultErrorHandlerServlet;
import org.apache.sling.servlets.resolver.internal.defaults.DefaultServlet;
import org.apache.sling.servlets.resolver.internal.helper.AbstractResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.NamedScriptResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.ResourceCollector;
import org.apache.sling.servlets.resolver.internal.helper.SlingServletConfig;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProvider;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProviderFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.servlets.resolver.SlingServletResolver", metatype=true, label="%servletresolver.name", description="%servletresolver.description")
@Service(value={ServletResolver.class, SlingScriptResolver.class, ErrorHandler.class})
@Properties(value={@Property(name="service.description", value={"Sling Servlet Resolver and Error Handler"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.ranking", intValue={10000}), @Property(name="event.topics", propertyPrivate=true, value={"org/apache/sling/api/resource/Resource/*", "org/apache/sling/api/resource/ResourceProvider/*", "javax/script/ScriptEngineFactory/*", "org/apache/sling/api/adapter/AdapterFactory/*"})})
@Reference(name="Servlet", referenceInterface=Servlet.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class SlingServletResolver
implements ServletResolver,
SlingScriptResolver,
ErrorHandler,
EventHandler {
    public static final String DEFAULT_SERVLET_ROOT = "0";
    public static final int DEFAULT_CACHE_SIZE = 200;
    public static final Logger LOGGER = LoggerFactory.getLogger(SlingServletResolver.class);
    @Property(value={"0"})
    public static final String PROP_SERVLET_ROOT = "servletresolver.servletRoot";
    @Property
    public static final String PROP_SCRIPT_USER = "servletresolver.scriptUser";
    @Property(intValue={200})
    public static final String PROP_CACHE_SIZE = "servletresolver.cacheSize";
    @Property
    public static final String PROP_DEFAULT_SCRIPT_WORKSPACE = "servletresolver.defaultScriptWorkspace";
    private static final boolean DEFAULT_USE_DEFAULT_WORKSPACE = false;
    @Property(boolValue={false})
    public static final String PROP_USE_REQUEST_WORKSPACE = "servletresolver.useRequestWorkspace";
    private static final boolean DEFAULT_USE_REQUEST_WORKSPACE = false;
    @Property(boolValue={false})
    public static final String PROP_USE_DEFAULT_WORKSPACE = "servletresolver.useDefaultWorkspace";
    private static final String REF_SERVLET = "Servlet";
    @Property(value={"/"}, unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_PATHS = "servletresolver.paths";
    private static final String[] DEFAULT_PATHS = new String[]{"/"};
    @Property(value={"html"}, unbounded=PropertyUnbounded.ARRAY)
    public static final String PROP_DEFAULT_EXTENSIONS = "servletresolver.defaultExtensions";
    private static final String[] DEFAULT_DEFAULT_EXTENSIONS = new String[]{"html"};
    @Reference
    private ServletContext servletContext;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private ResourceResolver scriptResolver;
    private final Map<ServiceReference, ServletReg> servletsByReference = new HashMap<ServiceReference, ServletReg>();
    private final List<ServiceReference> pendingServlets = new ArrayList<ServiceReference>();
    private ComponentContext context;
    private ServletResourceProviderFactory servletResourceProviderFactory;
    private Servlet defaultServlet;
    private Servlet fallbackErrorServlet;
    private Map<AbstractResourceCollector, Servlet> cache;
    private int cacheSize;
    private volatile boolean logCacheSizeWarning;
    private ServiceRegistration eventHandlerReg;
    private boolean useRequestWorkspace;
    private boolean useDefaultWorkspace;
    private String defaultWorkspaceName;
    private String[] executionPaths;
    private String[] defaultExtensions;
    private ServletResolverWebConsolePlugin plugin;
    private static final String[] NAME_PROPERTIES = new String[]{"sling.core.servletName", "component.name", "service.pid", "service.id"};

    public Servlet resolveServlet(SlingHttpServletRequest request) {
        Resource resource = request.getResource();
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "resolveServlet(" + resource + ")";
        tracker.startTimer(timerName);
        String type = resource.getResourceType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {}", (Object)resource);
        }
        Servlet servlet = null;
        if (this.useRequestWorkspace) {
            String wspName = this.getWorkspaceName(request);
            servlet = this.resolveServlet(request, type, this.scriptResolver, wspName);
            if (servlet == null && this.useDefaultWorkspace && wspName != null) {
                servlet = this.resolveServlet(request, type, this.scriptResolver, this.defaultWorkspaceName);
            }
        } else {
            servlet = this.resolveServlet(request, type, this.scriptResolver, this.defaultWorkspaceName);
        }
        if (servlet == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No specific servlet found, trying default");
            }
            servlet = this.getDefaultServlet();
        }
        if (servlet == null) {
            tracker.logTimer(timerName, "Servlet resolution failed. See log for details", new Object[0]);
        } else {
            tracker.logTimer(timerName, "Using servlet {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
        }
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource={}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)resource);
            } else {
                LOGGER.debug("No servlet found for resource={}", (Object)resource);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(Resource resource, String scriptName) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for resource {} with script name {}", (Object)resource, (Object)scriptName);
        }
        Servlet servlet = this.resolveServlet(this.scriptResolver, resource, scriptName);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for resource {} and script name {}", new Object[]{RequestUtil.getServletName((Servlet)servlet), resource, scriptName});
            } else {
                LOGGER.debug("No servlet found for resource {} and script name {}", (Object)resource, (Object)scriptName);
            }
        }
        return servlet;
    }

    public Servlet resolveServlet(ResourceResolver resolver, String scriptName) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resource resolver must not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("resolveServlet called for for script name {}", (Object)scriptName);
        }
        Servlet servlet = this.resolveServlet(this.scriptResolver, null, scriptName);
        if (LOGGER.isDebugEnabled()) {
            if (servlet != null) {
                LOGGER.debug("Servlet {} found for script name {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
            } else {
                LOGGER.debug("No servlet found for script name {}", (Object)scriptName);
            }
        }
        return servlet;
    }

    private Servlet resolveServlet(ResourceResolver resolver, Resource resource, String scriptName) {
        String scriptPath;
        Servlet servlet = null;
        if (scriptName.charAt(0) == '/' && this.isPathAllowed(scriptPath = ResourceUtil.normalize((String)scriptName))) {
            Resource res = resolver.getResource(scriptPath);
            if (res != null) {
                servlet = (Servlet)res.adaptTo(Servlet.class);
            }
            if (servlet != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Servlet {} found using absolute resource type {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)scriptName);
            }
        }
        if (servlet == null) {
            NamedScriptResourceCollector locationUtil = NamedScriptResourceCollector.create(scriptName, resource, this.executionPaths);
            servlet = this.getServlet(locationUtil, null, resolver);
            if (LOGGER.isDebugEnabled() && servlet != null) {
                LOGGER.debug("resolveServlet returns servlet {}", (Object)RequestUtil.getServletName((Servlet)servlet));
            }
        }
        return servlet;
    }

    public SlingScript findScript(ResourceResolver resourceResolver, String name) throws SlingException {
        SlingScript script = null;
        if (name.startsWith("/")) {
            Resource resource;
            String path = ResourceUtil.normalize((String)name);
            if (this.isPathAllowed(path) && (resource = resourceResolver.getResource(path)) != null) {
                script = (SlingScript)resource.adaptTo(SlingScript.class);
            }
        } else {
            String[] path = resourceResolver.getSearchPath();
            for (int i = 0; script == null && i < path.length; ++i) {
                Resource resource;
                String scriptPath = ResourceUtil.normalize((String)(path[i] + name));
                if (!this.isPathAllowed(scriptPath) || (resource = resourceResolver.getResource(scriptPath)) == null) continue;
                script = (SlingScript)resource.adaptTo(SlingScript.class);
            }
        }
        if (script != null) {
            LOGGER.debug("findScript: Using script {} for {}", (Object)script.getScriptResource().getPath(), (Object)name);
        } else {
            LOGGER.info("findScript: No script {} found in path", (Object)name);
        }
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(int status, String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling status " + status + "(" + message + ")");
            return;
        }
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "handleError:status=" + status;
        tracker.startTimer(timerName);
        try {
            String wspName = this.useRequestWorkspace ? this.getWorkspaceName(request) : null;
            Resource resource = this.getErrorResource(request);
            ResourceCollector locationUtil = new ResourceCollector(String.valueOf(status), "sling/servlet/errorhandler", resource, wspName, this.executionPaths);
            Servlet servlet = this.getServlet(locationUtil, request, this.scriptResolver);
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, this.scriptResolver, resource, wspName);
            }
            request.setAttribute("javax.servlet.error.status_code", (Object)new Integer(status));
            request.setAttribute("javax.servlet.error.message", (Object)message);
            Object servletName = request.getAttribute("sling.core.current.servletName");
            if (servletName instanceof String) {
                request.setAttribute("javax.servlet.error.servlet_name", servletName);
            }
            tracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            tracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleError(Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (request.getAttribute("javax.servlet.error.request_uri") != null) {
            LOGGER.error("handleError: Recursive invocation. Not further handling Throwable:", throwable);
            return;
        }
        RequestProgressTracker tracker = request.getRequestProgressTracker();
        String timerName = "handleError:throwable=" + throwable.getClass().getName();
        tracker.startTimer(timerName);
        try {
            String wspName = this.useRequestWorkspace ? this.getWorkspaceName(request) : null;
            Servlet servlet = null;
            Resource resource = this.getErrorResource(request);
            for (Class<?> tClass = throwable.getClass(); servlet == null && tClass != Object.class; tClass = tClass.getSuperclass()) {
                ResourceCollector locationUtil = new ResourceCollector(tClass.getSimpleName(), "sling/servlet/errorhandler", resource, wspName, this.executionPaths);
                servlet = this.getServlet(locationUtil, request, this.scriptResolver);
            }
            if (servlet == null) {
                servlet = this.getDefaultErrorServlet(request, this.scriptResolver, resource, wspName);
            }
            request.setAttribute("javax.servlet.error.exception", (Object)throwable);
            request.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
            request.setAttribute("javax.servlet.error.message", (Object)throwable.getMessage());
            tracker.logTimer(timerName, "Using handler {0}", new Object[]{RequestUtil.getServletName((Servlet)servlet)});
            this.handleError(servlet, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        finally {
            tracker.logTimer(timerName, "Error handler finished", new Object[0]);
        }
    }

    private Resource getErrorResource(SlingHttpServletRequest request) {
        Resource res = request.getResource();
        if (res == null) {
            res = new SyntheticResource(request.getResourceResolver(), request.getPathInfo(), "sling/servlet/errorhandler");
        }
        return res;
    }

    private Servlet resolveServlet(SlingHttpServletRequest request, String type, ResourceResolver resolver, String workspaceName) {
        ResourceCollector locationUtil;
        Servlet servlet = null;
        if (type.charAt(0) == '/') {
            String scriptPath = ResourceUtil.normalize((String)type);
            if (this.isPathAllowed(scriptPath)) {
                Resource res;
                if (workspaceName != null) {
                    scriptPath = workspaceName + ':' + type;
                }
                if ((res = resolver.getResource(scriptPath)) != null) {
                    servlet = (Servlet)res.adaptTo(Servlet.class);
                }
                if (servlet != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Servlet {} found using absolute resource type {}", (Object)RequestUtil.getServletName((Servlet)servlet), (Object)type);
                }
            } else {
                request.getRequestProgressTracker().log("Will not look for a servlet at {0} as it is not in the list of allowed paths", new Object[]{type});
            }
        }
        if (servlet == null && (servlet = this.getServlet(locationUtil = ResourceCollector.create(request, workspaceName, this.executionPaths, this.defaultExtensions), request, resolver)) != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("getServlet returns servlet {}", (Object)RequestUtil.getServletName((Servlet)servlet));
        }
        return servlet;
    }

    private Servlet getServlet(AbstractResourceCollector locationUtil, SlingHttpServletRequest request, ResourceResolver scriptResolver) {
        Servlet scriptServlet;
        Servlet servlet = scriptServlet = this.cache != null ? this.cache.get(locationUtil) : null;
        if (scriptServlet != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Using cached servlet {}", (Object)RequestUtil.getServletName((Servlet)scriptServlet));
            }
            return scriptServlet;
        }
        Collection<Resource> candidates = locationUtil.getServlets(scriptResolver);
        if (LOGGER.isDebugEnabled()) {
            if (candidates.isEmpty()) {
                LOGGER.debug("No servlet candidates found");
            } else {
                LOGGER.debug("Ordered list of servlet candidates follows");
                for (Resource candidateResource : candidates) {
                    LOGGER.debug("Servlet candidate: {}", (Object)candidateResource.getPath());
                }
            }
        }
        boolean hasOptingServlet = false;
        for (Resource candidateResource : candidates) {
            Servlet candidate;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Checking if candidate resource {} adapts to servlet and accepts request", (Object)candidateResource.getPath());
            }
            if ((candidate = (Servlet)candidateResource.adaptTo(Servlet.class)) != null) {
                boolean servletAcceptsRequest;
                boolean isOptingServlet = candidate instanceof OptingServlet;
                boolean bl = servletAcceptsRequest = !isOptingServlet || request != null && ((OptingServlet)candidate).accepts(request);
                if (servletAcceptsRequest) {
                    if (!hasOptingServlet && !isOptingServlet && this.cache != null) {
                        if (this.cache.size() < this.cacheSize) {
                            this.cache.put(locationUtil, candidate);
                        } else if (this.logCacheSizeWarning) {
                            this.logCacheSizeWarning = false;
                            LOGGER.warn("Script cache has reached its limit of {}. You might want to increase the cache size for the servlet resolver.", (Object)this.cacheSize);
                        }
                    }
                    LOGGER.debug("Using servlet provided by candidate resource {}", (Object)candidateResource.getPath());
                    return candidate;
                }
                if (isOptingServlet) {
                    hasOptingServlet = true;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Candidate {} does not accept request, ignored", (Object)candidateResource.getPath());
                continue;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Candidate {} does not adapt to a servlet, ignored", (Object)candidateResource.getPath());
        }
        return null;
    }

    private Servlet getDefaultServlet() {
        if (this.defaultServlet == null) {
            try {
                DefaultServlet servlet = new DefaultServlet();
                servlet.init(new SlingServletConfig(this.servletContext, null, "Sling Core Default Servlet"));
                this.defaultServlet = servlet;
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize default servlet", (Throwable)se);
            }
        }
        return this.defaultServlet;
    }

    private Servlet getDefaultErrorServlet(SlingHttpServletRequest request, ResourceResolver scriptResolver, Resource resource, String workspaceName) {
        ResourceCollector locationUtil = new ResourceCollector("default", "sling/servlet/errorhandler", resource, workspaceName, this.executionPaths);
        Servlet servlet = this.getServlet(locationUtil, request, scriptResolver);
        if (servlet != null) {
            return servlet;
        }
        if (this.fallbackErrorServlet == null) {
            try {
                DefaultErrorHandlerServlet defaultServlet = new DefaultErrorHandlerServlet();
                defaultServlet.init(new SlingServletConfig(this.servletContext, null, "Sling (Ad Hoc) Default Error Handler Servlet"));
                this.fallbackErrorServlet = defaultServlet;
            }
            catch (ServletException se) {
                LOGGER.error("Failed to initialize error servlet", (Throwable)se);
            }
        }
        return this.fallbackErrorServlet;
    }

    private void handleError(Servlet errorHandler, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        if (request.getAttribute("javax.servlet.error.servlet_name") == null) {
            request.setAttribute("javax.servlet.error.servlet_name", (Object)errorHandler.getServletConfig().getServletName());
        }
        try {
            errorHandler.service((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            LOGGER.error("Calling the error handler resulted in an error", t);
            LOGGER.error("Original error " + request.getAttribute("javax.servlet.error.exception_type"), (Throwable)request.getAttribute("javax.servlet.error.exception"));
        }
    }

    String getWorkspaceName(SlingHttpServletRequest request) {
        if (this.useRequestWorkspace) {
            String path = request.getResource().getPath();
            int pos = path.indexOf(":/");
            if (pos == -1) {
                return null;
            }
            return path.substring(0, pos);
        }
        return null;
    }

    private Map<String, Object> createAuthenticationInfo(Dictionary<String, Object> props) {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        String scriptUser = OsgiUtil.toString((Object)props.get(PROP_SCRIPT_USER), null);
        if (scriptUser != null && scriptUser.length() > 0) {
            authInfo.put("user.impersonation", scriptUser);
        }
        return authInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws LoginException {
        ArrayList<ServiceReference> refs;
        Dictionary properties = context.getProperties();
        Object servletRoot = properties.get(PROP_SERVLET_ROOT);
        if (servletRoot == null) {
            servletRoot = DEFAULT_SERVLET_ROOT;
        }
        this.useDefaultWorkspace = OsgiUtil.toBoolean(properties.get(PROP_USE_DEFAULT_WORKSPACE), (boolean)false);
        this.useRequestWorkspace = OsgiUtil.toBoolean(properties.get(PROP_USE_REQUEST_WORKSPACE), (boolean)false);
        String defaultWorkspaceProp = (String)properties.get(PROP_DEFAULT_SCRIPT_WORKSPACE);
        if (defaultWorkspaceProp != null && defaultWorkspaceProp.trim().length() == 0) {
            defaultWorkspaceProp = null;
        }
        this.defaultWorkspaceName = defaultWorkspaceProp;
        List<ServiceReference> list = this.pendingServlets;
        synchronized (list) {
            refs = new ArrayList<ServiceReference>(this.pendingServlets);
            this.pendingServlets.clear();
            this.scriptResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(this.createAuthenticationInfo(context.getProperties()));
            this.servletResourceProviderFactory = new ServletResourceProviderFactory(servletRoot, this.scriptResolver.getSearchPath());
            this.context = context;
        }
        this.createAllServlets(refs);
        this.executionPaths = OsgiUtil.toStringArray(properties.get(PROP_PATHS), (String[])DEFAULT_PATHS);
        if (this.executionPaths != null) {
            if (this.executionPaths.length == 0) {
                this.executionPaths = null;
            } else {
                boolean hasRoot = false;
                for (int i = 0; i < this.executionPaths.length; ++i) {
                    String path = this.executionPaths[i];
                    if (path != null && path.length() != 0 && !path.equals("/")) continue;
                    hasRoot = true;
                }
                if (hasRoot) {
                    this.executionPaths = null;
                }
            }
        }
        this.defaultExtensions = OsgiUtil.toStringArray(properties.get(PROP_DEFAULT_EXTENSIONS), (String[])DEFAULT_DEFAULT_EXTENSIONS);
        this.cacheSize = OsgiUtil.toInteger(properties.get(PROP_CACHE_SIZE), (int)200);
        if (this.cacheSize > 5) {
            this.cache = new ConcurrentHashMap<AbstractResourceCollector, Servlet>(this.cacheSize);
            this.logCacheSizeWarning = true;
        } else {
            this.cacheSize = 0;
        }
        this.eventHandlerReg = context.getBundleContext().registerService(EventHandler.class.getName(), (Object)this, properties);
        this.plugin = new ServletResolverWebConsolePlugin(context.getBundleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deactivate(ComponentContext context) {
        ArrayList<ServiceReference> refs;
        this.context = null;
        if (this.plugin != null) {
            this.plugin.dispose();
        }
        if (this.eventHandlerReg != null) {
            this.eventHandlerReg.unregister();
            this.eventHandlerReg = null;
        }
        Map<ServiceReference, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            refs = new ArrayList<ServiceReference>(this.servletsByReference.keySet());
        }
        this.destroyAllServlets(refs);
        map = this.servletsByReference;
        synchronized (map) {
            this.servletsByReference.clear();
        }
        if (this.fallbackErrorServlet != null) {
            try {
                this.fallbackErrorServlet.destroy();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.fallbackErrorServlet = null;
            }
        }
        if (this.scriptResolver != null) {
            this.scriptResolver.close();
            this.scriptResolver = null;
        }
        this.cache = null;
        this.servletResourceProviderFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindServlet(ServiceReference reference) {
        boolean directCreate = true;
        if (this.context == null) {
            List<ServiceReference> list = this.pendingServlets;
            synchronized (list) {
                if (this.context == null) {
                    this.pendingServlets.add(reference);
                    directCreate = false;
                }
            }
        }
        if (directCreate) {
            this.createServlet(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindServlet(ServiceReference reference) {
        List<ServiceReference> list = this.pendingServlets;
        synchronized (list) {
            this.pendingServlets.remove(reference);
        }
        this.destroyServlet(reference);
    }

    private void createAllServlets(Collection<ServiceReference> pendingServlets) {
        for (ServiceReference serviceReference : pendingServlets) {
            this.createServlet(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createServlet(ServiceReference reference) {
        String name = SlingServletResolver.getName(reference);
        if (name == null) {
            LOGGER.error("bindServlet: Cannot register servlet {} without a servlet name", (Object)reference);
            return false;
        }
        ServletResourceProvider provider = this.servletResourceProviderFactory.create(reference);
        if (provider == null) {
            return false;
        }
        Servlet servlet = null;
        try {
            servlet = (Servlet)this.context.locateService(REF_SERVLET, reference);
        }
        catch (Throwable t) {
            LOGGER.warn("bindServlet: Failed getting the service for reference " + reference, t);
        }
        if (servlet == null) {
            LOGGER.error("bindServlet: Servlet service not available from reference {}", (Object)reference);
            return false;
        }
        provider.setServlet(servlet);
        try {
            servlet.init((ServletConfig)new SlingServletConfig(this.servletContext, reference, name));
            LOGGER.debug("bindServlet: Servlet {} added", (Object)name);
        }
        catch (ServletException ce) {
            LOGGER.error("bindServlet: Component " + name + " failed to initialize", (Throwable)ce);
            return false;
        }
        catch (Throwable t) {
            LOGGER.error("bindServlet: Unexpected problem initializing component " + name, t);
            return false;
        }
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        ((Dictionary)params).put("provider.roots", provider.getServletPaths());
        ((Dictionary)params).put("service.description", "ServletResourceProvider for Servlets at " + Arrays.asList(provider.getServletPaths()));
        ServiceRegistration reg = this.context.getBundleContext().registerService(ResourceProvider.SERVICE_NAME, (Object)provider, params);
        LOGGER.info("Registered {}", (Object)provider.toString());
        Map<ServiceReference, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            this.servletsByReference.put(reference, new ServletReg(servlet, reg));
        }
        return true;
    }

    private void destroyAllServlets(Collection<ServiceReference> refs) {
        for (ServiceReference serviceReference : refs) {
            this.destroyServlet(serviceReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyServlet(ServiceReference reference) {
        ServletReg registration;
        Map<ServiceReference, ServletReg> map = this.servletsByReference;
        synchronized (map) {
            registration = this.servletsByReference.remove(reference);
        }
        if (registration != null) {
            registration.registration.unregister();
            String name = RequestUtil.getServletName((Servlet)registration.servlet);
            LOGGER.debug("unbindServlet: Servlet {} removed", (Object)name);
            try {
                registration.servlet.destroy();
            }
            catch (Throwable t) {
                LOGGER.error("unbindServlet: Unexpected problem destroying servlet " + name, t);
            }
        }
    }

    public void handleEvent(Event event) {
        if (this.cache != null) {
            boolean flushCache = false;
            String topic = event.getTopic();
            if (topic.startsWith("javax/script/ScriptEngineFactory/")) {
                flushCache = true;
            } else if (topic.startsWith("org/apache/sling/api/adapter/AdapterFactory/")) {
                flushCache = true;
            } else {
                String path = (String)event.getProperty("path");
                if (path.contains(":")) {
                    path = path.substring(path.indexOf(":") + 1);
                }
                String[] searchPaths = this.scriptResolver.getSearchPath();
                for (int index = 0; !flushCache && index < searchPaths.length; ++index) {
                    if (!path.startsWith(searchPaths[index])) continue;
                    flushCache = true;
                }
            }
            if (flushCache) {
                this.cache.clear();
                this.logCacheSizeWarning = true;
            }
        }
    }

    private static String getName(ServiceReference reference) {
        String servletName = null;
        for (int i = 0; i < NAME_PROPERTIES.length && (servletName == null || servletName.length() == 0); ++i) {
            Object prop = reference.getProperty(NAME_PROPERTIES[i]);
            if (prop == null) continue;
            servletName = String.valueOf(prop);
        }
        return servletName;
    }

    private boolean isPathAllowed(String path) {
        return AbstractResourceCollector.isPathAllowed(path, this.executionPaths);
    }

    protected void bindServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected void unbindServletContext(ServletContext servletContext) {
        if (this.servletContext == servletContext) {
            this.servletContext = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServletResolverWebConsolePlugin
    extends HttpServlet {
        private static final String PARAMETER_URL = "url";
        private static final String PARAMETER_METHOD = "method";
        private ServiceRegistration service;

        public ServletResolverWebConsolePlugin(BundleContext context) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.description", "Sling Servlet Resolver Web Console Plugin");
            ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
            ((Dictionary)props).put("service.pid", ((Object)((Object)this)).getClass().getName());
            ((Dictionary)props).put("felix.webconsole.label", "servletresolver");
            ((Dictionary)props).put("felix.webconsole.title", "Sling Servlet Resolver");
            ((Dictionary)props).put("felix.webconsole.css", "/servletresolver/res/ui/styles.css");
            this.service = context.registerService(new String[]{"javax.servlet.Servlet"}, (Object)this, props);
        }

        public void dispose() {
            if (this.service != null) {
                this.service.unregister();
                this.service = null;
            }
        }

        protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String url = request.getParameter(PARAMETER_URL);
            DecomposedURL decomposed = new DecomposedURL(url);
            String method = request.getParameter(PARAMETER_METHOD);
            if (StringUtils.isBlank((String)method)) {
                method = "GET";
            }
            ResourceResolver resourceResolver = null;
            try {
                resourceResolver = SlingServletResolver.this.resourceResolverFactory.getAdministrativeResourceResolver(null);
                PrintWriter pw = response.getWriter();
                pw.print("<form method='get'>");
                pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
                this.titleHtml(pw, "Servlet Resolver Test", "To check which servlet is responsible for rendering a response, enter a request path into the field and click 'Resolve' to resolve it.");
                this.tr(pw);
                this.tdLabel(pw, "URL");
                this.tdContent(pw);
                pw.println("<input type='text' name='url' value='" + (url != null ? url : "") + "' class='input' size='50'>");
                this.closeTd(pw);
                this.closeTr(pw);
                this.closeTr(pw);
                this.tr(pw);
                this.tdLabel(pw, "Method");
                this.tdContent(pw);
                pw.println("<select name='method'>");
                pw.println("<option value='GET'>GET</option>");
                pw.println("<option value='POST'>POST</option>");
                pw.println("</select>");
                pw.println("&nbsp;&nbsp;<input type='submit'' value='Resolve' class='submit'>");
                this.closeTd(pw);
                this.closeTr(pw);
                if (StringUtils.isNotBlank((String)url)) {
                    this.tr(pw);
                    this.tdLabel(pw, "Decomposed URL");
                    this.tdContent(pw);
                    pw.println("<dl>");
                    pw.println("<dt>Path</dt>");
                    pw.println("<dd>" + decomposed.path + "</dd>");
                    pw.println("<dt>Selectors</dt>");
                    pw.print("<dd>");
                    if (decomposed.selectors.length == 0) {
                        pw.print("&lt;none&gt;");
                    } else {
                        pw.print("[");
                        pw.print(StringUtils.join((Object[])decomposed.selectors, (String)", "));
                        pw.print("]");
                    }
                    pw.println("</dd>");
                    pw.println("<dt>Extension</dt>");
                    pw.println("<dd>" + decomposed.extension + "</dd>");
                    pw.println("</dl>");
                    this.closeTd(pw);
                    this.closeTr(pw);
                }
                if (StringUtils.isNotBlank((String)decomposed.path)) {
                    Collection<Resource> servlets;
                    Resource resource = resourceResolver.resolve(decomposed.path);
                    if (resource.adaptTo(Servlet.class) != null) {
                        servlets = Collections.singleton(resource);
                    } else {
                        ResourceCollector locationUtil = ResourceCollector.create(resource, SlingServletResolver.this.defaultWorkspaceName, decomposed.extension, SlingServletResolver.this.executionPaths, SlingServletResolver.this.defaultExtensions, method, decomposed.selectors);
                        servlets = locationUtil.getServlets(resourceResolver);
                    }
                    this.tr(pw);
                    this.tdLabel(pw, "&nbsp;");
                    this.tdContent(pw);
                    if (servlets == null || servlets.isEmpty()) {
                        pw.println("Could not find a suitable servlet for this request!");
                    } else {
                        pw.println("Candidate servlets and scripts in order of preference:<br/>");
                        pw.println("<ol class='servlets'>");
                        Iterator<Resource> iterator = servlets.iterator();
                        this.outputServlets(pw, iterator);
                        pw.println("</ol>");
                    }
                    pw.println("</td>");
                    this.closeTr(pw);
                }
                pw.println("</table>");
                pw.print("</form>");
            }
            catch (LoginException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                if (resourceResolver != null) {
                    resourceResolver.close();
                }
            }
        }

        private void tdContent(PrintWriter pw) {
            pw.print("<td class='content' colspan='2'>");
        }

        private void closeTd(PrintWriter pw) {
            pw.print("</td>");
        }

        private URL getResource(String path) {
            if (path.startsWith("/servletresolver/res/ui")) {
                return ((Object)((Object)this)).getClass().getResource(path.substring(16));
            }
            return null;
        }

        private void closeTr(PrintWriter pw) {
            pw.println("</tr>");
        }

        private void tdLabel(PrintWriter pw, String label) {
            pw.println("<td class='content'>" + label + "</td>");
        }

        private void tr(PrintWriter pw) {
            pw.println("<tr class='content'>");
        }

        private void outputServlets(PrintWriter pw, Iterator<Resource> iterator) {
            while (iterator.hasNext()) {
                Resource candidateResource = iterator.next();
                Servlet candidate = (Servlet)candidateResource.adaptTo(Servlet.class);
                if (candidate == null) continue;
                boolean isOptingServlet = false;
                if (candidate instanceof SlingScript) {
                    pw.println("<li>" + candidateResource.getPath() + "</li>");
                    continue;
                }
                if (candidate instanceof OptingServlet) {
                    isOptingServlet = true;
                }
                pw.println("<li>" + candidate.getClass().getName() + (isOptingServlet ? " (OptingServlet)" : "") + "</li>");
            }
        }

        private void titleHtml(PrintWriter pw, String title, String description) {
            this.tr(pw);
            pw.println("<th colspan='3' class='content container'>" + title + "</th>");
            this.closeTr(pw);
            if (description != null) {
                this.tr(pw);
                pw.println("<td colspan='3' class='content'>" + description + "</th>");
                this.closeTr(pw);
            }
        }

        class DecomposedURL {
            final String extension;
            final String path;
            final String[] selectors;

            DecomposedURL(String url) {
                if (url != null) {
                    int lastDot = url.lastIndexOf(46);
                    int firstDot = url.indexOf(46);
                    if (lastDot > 0) {
                        int slashInExtension = url.indexOf(47, lastDot);
                        this.extension = slashInExtension > 0 ? url.substring(lastDot + 1, slashInExtension) : url.substring(lastDot + 1);
                        this.path = url.substring(0, firstDot);
                        if (lastDot != firstDot) {
                            String selectorString = url.substring(firstDot + 1, lastDot);
                            this.selectors = selectorString.split("\\.");
                        } else {
                            this.selectors = new String[0];
                        }
                    } else {
                        this.extension = "";
                        this.path = url;
                        this.selectors = new String[0];
                    }
                } else {
                    this.extension = "";
                    this.path = "";
                    this.selectors = new String[0];
                }
            }
        }
    }

    private static final class ServletReg {
        public final Servlet servlet;
        public final ServiceRegistration registration;

        public ServletReg(Servlet s, ServiceRegistration sr) {
            this.servlet = s;
            this.registration = sr;
        }
    }
}

