/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.servlets.resolver.internal.SlingServletResolver;
import org.apache.sling.servlets.resolver.internal.helper.LocationIterator;
import org.apache.sling.servlets.resolver.internal.helper.WeightedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceCollector {
    protected final String baseResourceType;
    protected final String extension;
    protected int hashCode;
    protected final String resourceType;
    protected final String resourceSuperType;
    protected final String[] executionPaths;
    protected final String workspaceName;

    public AbstractResourceCollector(String baseResourceType, String resourceType, String resourceSuperType, String workspaceName, String extension, String[] executionPaths) {
        this.baseResourceType = baseResourceType;
        this.resourceType = resourceType;
        this.resourceSuperType = resourceSuperType;
        this.extension = extension;
        this.executionPaths = executionPaths;
        this.workspaceName = workspaceName;
    }

    public final Collection<Resource> getServlets(ResourceResolver resolver) {
        TreeSet<Resource> resources = new TreeSet<Resource>();
        LocationIterator locations = new LocationIterator(this.resourceType, this.resourceSuperType, this.baseResourceType, this.workspaceName, resolver);
        while (locations.hasNext()) {
            String location = (String)locations.next();
            String path = location.endsWith("/") ? location.substring(0, location.length() - 1) : location;
            Resource locationRes = this.getResource(resolver, path);
            this.getWeightedResources(resources, locationRes);
        }
        return resources;
    }

    protected abstract void getWeightedResources(Set<Resource> var1, Resource var2);

    protected final void addWeightedResource(Set<Resource> resources, Resource resource, int numSelectors, int methodPrefixWeight) {
        WeightedResource lr = new WeightedResource(resources.size(), resource, numSelectors, methodPrefixWeight);
        resources.add((Resource)lr);
    }

    protected final Resource getResource(ResourceResolver resolver, String path) {
        Resource res;
        if (this.workspaceName != null) {
            path = this.workspaceName + ':' + path;
        }
        if ((res = resolver.getResource(path)) == null) {
            if (!path.startsWith("/")) {
                path = "/".concat(path);
            }
            res = new SyntheticResource(resolver, path, "$synthetic$");
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractResourceCollector)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractResourceCollector o = (AbstractResourceCollector)obj;
        return this.stringEquals(this.resourceType, o.resourceType) && this.stringEquals(this.resourceSuperType, o.resourceSuperType) && this.stringEquals(this.extension, o.extension) && this.stringEquals(this.baseResourceType, o.baseResourceType) && this.stringEquals(this.workspaceName, o.workspaceName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected boolean stringEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    protected boolean isPathAllowed(String path) {
        return AbstractResourceCollector.isPathAllowed(path, this.executionPaths);
    }

    public static boolean isPathAllowed(String path, String[] executionPaths) {
        if (executionPaths == null || executionPaths.length == 0) {
            SlingServletResolver.LOGGER.debug("Accepting servlet at '{}' as there are no configured execution paths.", (Object)path);
            return true;
        }
        if (path == null || path.length() == 0) {
            SlingServletResolver.LOGGER.debug("Ignoring servlet with empty path.");
            return false;
        }
        for (String config : executionPaths) {
            if (config.endsWith("/")) {
                if (!path.startsWith(config)) continue;
                SlingServletResolver.LOGGER.debug("Accepting servlet at '{}' as the path is prefixed with configured execution path '{}'.", (Object)path, (Object)config);
                return true;
            }
            if (!path.equals(config)) continue;
            SlingServletResolver.LOGGER.debug("Accepting servlet at '{}' as the path equals configured execution path '{}'.", (Object)path, (Object)config);
            return true;
        }
        if (SlingServletResolver.LOGGER.isDebugEnabled()) {
            SlingServletResolver.LOGGER.debug("Ignoring servlet at '{}' as the path is not in the configured execution paths.", (Object)path);
        }
        return false;
    }
}

