/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.helper;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WeightedResource
extends ResourceWrapper
implements Comparable<WeightedResource> {
    static final int WEIGHT_NONE = 0;
    static final int WEIGHT_LAST_RESSORT = -1;
    static final int WEIGHT_PREFIX = 1;
    static final int WEIGHT_EXTENSION = 2;
    private final int ordinal;
    private final int numSelectors;
    private final int methodPrefixWeight;

    WeightedResource(int ordinal, Resource resource, int numSelectors, int methodPrefixWeight) {
        super(resource);
        this.ordinal = ordinal;
        this.numSelectors = numSelectors;
        this.methodPrefixWeight = methodPrefixWeight;
    }

    public final int getOrdinal() {
        return this.ordinal;
    }

    public final int getNumSelectors() {
        return this.numSelectors;
    }

    public final int getMethodPrefixWeight() {
        return this.methodPrefixWeight;
    }

    public final int hashCode() {
        return this.ordinal;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.getOrdinal() + "]: " + this.getResource() + ", #selectors=" + this.getNumSelectors() + ", methodPrefixWeight=" + this.getMethodPrefixWeight();
    }

    @Override
    public final int compareTo(WeightedResource o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.numSelectors > o.numSelectors) {
            return -1;
        }
        if (this.numSelectors < o.numSelectors) {
            return 1;
        }
        if (this.methodPrefixWeight > o.methodPrefixWeight) {
            return -1;
        }
        if (this.methodPrefixWeight < o.methodPrefixWeight) {
            return 1;
        }
        return this.ordinal < o.ordinal ? -1 : 1;
    }
}

