/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.resolver.internal.resource.ServletResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletResourceProvider
implements ResourceProvider {
    private static final Iterator<Resource> EMPTY_ITERATOR = new Iterator<Resource>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Resource next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    private Servlet servlet;
    private Set<String> resourcePaths;

    ServletResourceProvider(Set<String> resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public void setServlet(Servlet servlet) {
        this.servlet = servlet;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        if (this.servlet != null && this.resourcePaths.contains(path)) {
            return new ServletResource(resourceResolver, this.servlet, path);
        }
        return null;
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return EMPTY_ITERATOR;
    }

    Servlet getServlet() {
        return this.servlet;
    }

    Iterator<String> getServletPathIterator() {
        return this.resourcePaths.iterator();
    }

    public String[] getServletPaths() {
        return this.resourcePaths.toArray(new String[this.resourcePaths.size()]);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": servlet=" + this.servlet.getClass().getName() + ", paths=" + Arrays.toString(this.getServletPaths());
    }
}

