/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.settings.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingSettingsServiceImpl
implements SlingSettingsService {
    private static final String SLING_NAME = "sling.name";
    private static final String SLING_DESCRIPTION = "sling.description";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String slingId;
    private String slingHome;
    private URL slingHomeUrl;
    private Set<String> runModes;
    private static final String ID_FILE = "sling.id.file";
    private static final String OPTIONS_FILE = "sling.options.file";
    private final Map<String, String> slingProps = new HashMap<String, String>();

    public SlingSettingsServiceImpl(BundleContext context, StartupHandler handler) {
        this.setupSlingProps(context);
        this.setupSlingHome(context);
        this.setupSlingId(context);
        StartupMode mode = handler.getMode();
        this.logger.debug("Settings: Using startup mode : {}", (Object)mode);
        this.setupRunModes(context, mode);
    }

    private void setupSlingHome(BundleContext context) {
        this.slingHome = context.getProperty("sling.home");
        String url = context.getProperty("sling.home.url");
        if (url != null) {
            try {
                this.slingHomeUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                this.logger.error("Sling home url is not a url: {}", (Object)url);
            }
        }
    }

    private void setupSlingId(BundleContext context) {
        File idFile = context.getDataFile(ID_FILE);
        if (idFile == null) {
            throw new RuntimeException("Unable to read from bundle data file.");
        }
        this.slingId = this.readSlingId(idFile);
        if (this.slingId == null) {
            this.slingId = UUID.randomUUID().toString();
            this.writeSlingId(idFile, this.slingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSlingProps(BundleContext context) {
        Map<String, String> map = this.slingProps;
        synchronized (map) {
            if (this.slingProps.get(SLING_NAME) == null && context.getProperty(SLING_NAME) != null) {
                this.slingProps.put(SLING_NAME, context.getProperty(SLING_NAME));
            }
            if (this.slingProps.get(SLING_DESCRIPTION) == null && context.getProperty(SLING_DESCRIPTION) != null) {
                this.slingProps.put(SLING_DESCRIPTION, context.getProperty(SLING_DESCRIPTION));
            }
        }
    }

    private List<Options> handleOptions(Set<String> modesSet, String propOptions) {
        ArrayList<Options> optionsList = new ArrayList<Options>();
        if (propOptions != null && propOptions.trim().length() > 0) {
            String[] options;
            for (String opt : options = propOptions.trim().split("\\|")) {
                String selected = null;
                String[] modes = opt.trim().split(",");
                for (int i = 0; i < modes.length; ++i) {
                    modes[i] = modes[i].trim();
                    if (selected != null) {
                        modesSet.remove(modes[i]);
                        continue;
                    }
                    if (!modesSet.contains(modes[i])) continue;
                    selected = modes[i];
                }
                if (selected == null) {
                    selected = modes[0];
                    modesSet.add(modes[0]);
                }
                Options o = new Options();
                o.selected = selected;
                o.modes = modes;
                optionsList.add(o);
            }
        }
        return optionsList;
    }

    private void setupRunModes(BundleContext context, StartupMode startupMode) {
        List<Options> storedOptions;
        HashSet<String> modesSet = new HashSet<String>();
        String prop = context.getProperty("sling.run.modes");
        if (prop != null && prop.trim().length() > 0) {
            String[] modes = prop.split(",");
            for (int i = 0; i < modes.length; ++i) {
                modesSet.add(modes[i].trim());
            }
        }
        this.handleOptions(modesSet, context.getProperty("sling.run.mode.options"));
        if (startupMode != StartupMode.INSTALL && (storedOptions = this.readOptions(context)) != null) {
            for (Options o : storedOptions) {
                for (String m : o.modes) {
                    modesSet.remove(m);
                }
                modesSet.add(o.selected);
            }
        }
        if (startupMode != StartupMode.RESTART) {
            List<Options> optionsList = this.handleOptions(modesSet, context.getProperty("sling.run.mode.install.options"));
            this.writeOptions(context, optionsList);
        }
        this.runModes = Collections.synchronizedSet(Collections.unmodifiableSet(modesSet));
        if (this.runModes.size() > 0) {
            this.logger.info("Active run modes: {}", this.runModes);
        } else {
            this.logger.info("No run modes active");
        }
    }

    private List<Options> readOptions(BundleContext context) {
        List optionsList = null;
        File file = context.getDataFile(OPTIONS_FILE);
        if (file.exists()) {
            FileInputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = new FileInputStream(file);
                ois = new ObjectInputStream(fis);
                optionsList = (List)ois.readObject();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to read from options data file.", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Unable to read from options data file.", cnfe);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ignore) {}
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return optionsList;
    }

    private void writeOptions(BundleContext context, List<Options> optionsList) {
        File file = context.getDataFile(OPTIONS_FILE);
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(optionsList);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write to options data file.", ioe);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ignore) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSlingId(File idFile) {
        if (idFile.exists() && idFile.length() >= 36L) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(idFile);
                byte[] rawBytes = new byte[36];
                if (fin.read(rawBytes) == 36) {
                    String rawString = new String(rawBytes, "ISO-8859-1");
                    String id = UUID.fromString(rawString).toString();
                    this.logger.debug("Got Sling ID {} from file {}", (Object)id, (Object)idFile);
                    String string = id;
                    return string;
                }
            }
            catch (Throwable t) {
                this.logger.error("Failed reading UUID from id file " + idFile + ", creating new id", t);
            }
            finally {
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSlingId(File idFile, String id) {
        idFile.delete();
        idFile.getParentFile().mkdirs();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(idFile);
            fout.write(this.slingId.getBytes("ISO-8859-1"));
            fout.flush();
        }
        catch (Throwable t) {
            this.logger.error("Failed writing UUID to id file " + idFile, t);
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    @Override
    public String getAbsolutePathWithinSlingHome(String relativePath) {
        return new File(this.slingHome, relativePath).getAbsolutePath();
    }

    @Override
    public String getSlingId() {
        return this.slingId;
    }

    @Override
    public URL getSlingHome() {
        return this.slingHomeUrl;
    }

    @Override
    public String getSlingHomePath() {
        return this.slingHome;
    }

    @Override
    public Set<String> getRunModes() {
        return this.runModes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSlingName() {
        Map<String, String> map = this.slingProps;
        synchronized (map) {
            String name = this.slingProps.get(SLING_NAME);
            if (name == null) {
                name = "Instance " + this.slingId;
            }
            return name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSlingDescription() {
        Map<String, String> map = this.slingProps;
        synchronized (map) {
            String desc = this.slingProps.get(SLING_DESCRIPTION);
            if (desc == null) {
                desc = "Instance with id " + this.slingId + " and run modes " + this.getRunModes();
            }
            return desc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Dictionary<String, Object> properties) {
        if (properties != null) {
            Map<String, String> map = this.slingProps;
            synchronized (map) {
                if (properties.get(SLING_NAME) != null) {
                    this.slingProps.put(SLING_NAME, properties.get(SLING_NAME).toString());
                }
                if (properties.get(SLING_DESCRIPTION) != null) {
                    this.slingProps.put(SLING_DESCRIPTION, properties.get(SLING_DESCRIPTION).toString());
                }
            }
        }
    }

    private static final class Options
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String[] modes;
        String selected;

        private Options() {
        }
    }
}

