/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.impl.builder;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class ExtensionWriter
implements XMLStreamWriter {
    private final XMLStreamWriter delegate;
    private final String namespace;

    ExtensionWriter(XMLStreamWriter delegate, String namespace) {
        this.delegate = delegate;
        this.namespace = namespace;
    }

    private void ensureCurrentNamespace(String givenNamespace) {
        if (!this.namespace.equals(givenNamespace)) {
            throw new IllegalArgumentException("Writing with another namespace not permitted: " + givenNamespace);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement(this.namespace, localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.ensureCurrentNamespace(namespaceURI);
        this.delegate.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.ensureCurrentNamespace(namespaceURI);
        this.delegate.writeStartElement(localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(this.namespace, localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.ensureCurrentNamespace(namespaceURI);
        this.delegate.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.ensureCurrentNamespace(namespaceURI);
        this.delegate.writeEmptyElement(localName, namespaceURI);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.delegate.writeEndElement();
    }

    @Override
    public void writeEndDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.ensureCurrentNamespace(namespaceURI);
        this.delegate.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeComment(String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeProcessingInstruction(String target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeEntityRef(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeStartDocument() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeStartDocument(String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.delegate.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDefaultNamespace(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }
}

