/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tenant.internal;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.tenant.Tenant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TenantImpl
implements Tenant {
    private final String id;
    private ValueMap vm;

    TenantImpl(Resource resource) {
        this.id = resource.getName();
        this.loadProperties(resource);
    }

    void loadProperties(Resource resource) {
        ValueMap jcrVM = ResourceUtil.getValueMap((Resource)resource);
        HashMap localMap = new HashMap();
        localMap.putAll(jcrVM);
        ValueMapDecorator localVM = new ValueMapDecorator(localMap);
        this.vm = localVM;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return (String)this.vm.get("tenant.name", String.class);
    }

    @Override
    public String getDescription() {
        return (String)this.vm.get("tenant.description", String.class);
    }

    @Override
    public Object getProperty(String name) {
        return this.vm.get((Object)name);
    }

    @Override
    public <Type> Type getProperty(String name, Type type) {
        return (Type)this.vm.get(name, type);
    }

    @Override
    public Iterator<String> getPropertyNames() {
        return this.vm.keySet().iterator();
    }
}

