/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tenant.internal.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.tenant.Tenant;
import org.apache.sling.tenant.internal.TenantProviderImpl;
import org.apache.sling.xss.XSSAPI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class WebConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = -6983227434841706385L;
    private static final String LABEL = "tenants";
    private static final String TITLE = "Tenant Administration";
    private static final String CATEGORY = "Sling";
    private static final String REQ_PRM_TENANT_NAME = "tenantName";
    private static final String REQ_PRM_TENANT_ID = "tenantId";
    private static final String REQ_PRM_TENANT_DESC = "tenantDesc";
    private TenantProviderImpl tenantProvider;
    private final ServiceRegistration<Servlet> service;
    private final XSSAPI xss;

    public WebConsolePlugin(BundleContext bundleContext, TenantProviderImpl tenantProvider, XSSAPI xss) {
        this.tenantProvider = tenantProvider;
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Sling Tenant Management Console");
        ((Dictionary)props).put("felix.webconsole.label", LABEL);
        ((Dictionary)props).put("felix.webconsole.title", TITLE);
        ((Dictionary)props).put("felix.webconsole.category", CATEGORY);
        this.xss = xss;
        this.service = bundleContext.registerService(Servlet.class, (Object)this, props);
    }

    public void dispose() {
        this.service.unregister();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String msg = null;
        String cmd = req.getParameter("action");
        if ("create".equals(cmd)) {
            Tenant t = this.createTenant(req);
            msg = t != null ? String.format("Created Tenant %s (%s)", t.getName(), t.getDescription()) : "Cannot create tenant";
        } else if ("remove".equals(cmd)) {
            this.removeTenant(req);
        } else {
            msg = "Unknown command";
        }
        String path = LABEL;
        String redirectTo = msg == null ? LABEL : LABEL.concat("?message=").concat(URLEncoder.encode(msg, "UTF-8"));
        resp.sendRedirect(resp.encodeRedirectURL(redirectTo));
    }

    private void removeTenant(HttpServletRequest request) {
        String tenantId = request.getParameter(REQ_PRM_TENANT_ID);
        Tenant tenant = this.tenantProvider.getTenant(tenantId);
        if (tenant != null) {
            this.tenantProvider.remove(tenant);
        }
    }

    private void printForm(PrintWriter pw, Tenant t, String buttonLabel, String cmd) {
        pw.printf("<button class='ui-state-default ui-corner-all' onclick='javascript:cmdsubmit(\"%s\", \"%s\");'>%s</button>", cmd, t != null ? this.xss.encodeForJSString(t.getId()) : "", this.xss.encodeForHTML(buttonLabel));
    }

    private Tenant createTenant(HttpServletRequest request) {
        final String tenantName = request.getParameter(REQ_PRM_TENANT_NAME);
        String tenantId = request.getParameter(REQ_PRM_TENANT_ID);
        final String tenantDesc = request.getParameter(REQ_PRM_TENANT_DESC);
        return this.tenantProvider.create(tenantId, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("tenant.name", tenantName);
                this.put("tenant.description", tenantDesc);
            }
        });
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        PrintWriter pw = res.getWriter();
        pw.println("<form method='POST' name='cmd'><input type='hidden' name='action' value=''/><input type='hidden' name='tenantId' value=''/></form>");
        pw.println("<script type='text/javascript'>");
        pw.println("function cmdsubmit(action, tenantId) { document.forms['cmd'].action.value = action; document.forms['cmd'].tenantId.value = tenantId; document.forms['cmd'].submit();} function createsubmit() { document.forms['editorForm'].submit();} </script>");
        pw.printf("<p class='statline ui-state-highlight'>Apache Sling Tenant Support</p>", new Object[0]);
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.println("<span style='float: left; margin-left: 1em'>Add New Tenant </span>");
        pw.println("<button class='ui-state-default ui-corner-all' onclick='javascript:createsubmit();'> Create </button></div></td></tr>");
        pw.println("</div>");
        pw.println("<table id='editortable' class='nicetable'><tbody>");
        pw.println("<tr width='100%'><td colspan='2'><form id='editorForm' method='POST'>");
        pw.println("<input name='action' type='hidden' value='create' class='ui-state-default ui-corner-all'>");
        pw.println("<table border='0' width='100%'><tbody>");
        pw.println("<tr><td style='width: 30%;'>Identifier</td><td>");
        pw.println("<div><input name='tenantId' type='text' value=''></div>");
        pw.println("</td></tr>");
        pw.println("<tr><td style='width: 30%;'>Name</td><td>");
        pw.println("<div><input name='tenantName' type='text' value=''></div>");
        pw.println("</td></tr>");
        pw.println("<tr><td style='width: 30%;'>Description</td><td>");
        pw.println("<div><input name='tenantDesc' type='text' value=''></div>");
        pw.println("</td></tr>");
        pw.println("</tbody></table></form>");
        pw.println("</tbody></table>");
        Iterator<Tenant> tenants = this.tenantProvider.getTenants();
        int count = 0;
        while (tenants.hasNext()) {
            Tenant tenant = tenants.next();
            if (++count == 1) {
                pw.printf("<p class='statline ui-state-highlight'>Registered Tenants</p>", new Object[0]);
            }
            pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
            pw.printf("<span style='float: left; margin-left: 1em'>Tenant : %s </span>", this.xss.encodeForHTML(tenant.getName()));
            this.printForm(pw, tenant, "Remove", "remove");
            pw.println("</div>");
            pw.println("<table class='nicetable'><tbody>");
            pw.printf("<tr><td style='width: 30%%;'>Identifier</td><td>%s</td></tr>", this.xss.encodeForHTML(tenant.getId()));
            pw.printf("<tr><td style='width: 30%%;'>Name</td><td>%s</td></tr>", this.xss.encodeForHTML(tenant.getName()));
            pw.printf("<tr><td style='width: 30%%;'>Description</td><td>%s</td></tr>", this.xss.encodeForHTML(tenant.getDescription()));
            pw.println("</tbody></table>");
        }
        if (count == 0) {
            pw.printf("<p class='statline ui-state-highlight'>There are no registered tenants</p>", new Object[0]);
        }
    }
}

