/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.caconfig;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.mock.osgi.ManifestScanner;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

final class ConfigurationMetadataUtil {
    private static final String[] CONFIGURATION_CLASSES_FROM_MANIFEST = ConfigurationMetadataUtil.toArray(ManifestScanner.getValues((String)"Sling-ContextAware-Configuration-Classes"));

    private ConfigurationMetadataUtil() {
    }

    private static String[] toArray(Collection<String> values) {
        return values.toArray(new String[values.size()]);
    }

    public static void registerAnnotationClasses(BundleContext bundleContext, String ... classNames) {
        RegisterConfigurationMetadataBundle bundle = new RegisterConfigurationMetadataBundle(bundleContext, 32, classNames);
        BundleEvent event = new BundleEvent(2, (Bundle)bundle);
        MockOsgi.sendBundleEvent((BundleContext)bundleContext, (BundleEvent)event);
    }

    public static void registerAnnotationClasses(BundleContext bundleContext, Class ... classes) {
        String[] classNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            classNames[i] = classes[i].getName();
        }
        ConfigurationMetadataUtil.registerAnnotationClasses(bundleContext, classNames);
    }

    public static void addAnnotationClassesForManifestEntries(BundleContext bundleContext) {
        if (CONFIGURATION_CLASSES_FROM_MANIFEST.length > 0) {
            ConfigurationMetadataUtil.registerAnnotationClasses(bundleContext, CONFIGURATION_CLASSES_FROM_MANIFEST);
        }
    }

    private static class RegisterConfigurationMetadataBundle
    implements Bundle {
        private final BundleContext bundleContext;
        private final int state;
        private final String classNames;

        public RegisterConfigurationMetadataBundle(BundleContext bundleContext, int state, String[] classNames) {
            this.bundleContext = bundleContext;
            this.state = state;
            this.classNames = this.normalizeValueList(classNames);
        }

        private String normalizeValueList(String[] values) {
            if (values == null || values.length == 0) {
                return null;
            }
            return StringUtils.join((Object[])values, (String)",");
        }

        public int getState() {
            return this.state;
        }

        public Dictionary<String, String> getHeaders() {
            Hashtable<String, String> headers = new Hashtable<String, String>();
            ((Dictionary)headers).put("Sling-ContextAware-Configuration-Classes", this.classNames);
            return headers;
        }

        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            return new Vector().elements();
        }

        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.getClass().getClassLoader().loadClass(name);
        }

        public BundleContext getBundleContext() {
            return this.bundleContext;
        }

        public void start(int options) throws BundleException {
        }

        public void start() throws BundleException {
        }

        public void stop(int options) throws BundleException {
        }

        public void stop() throws BundleException {
        }

        public void update(InputStream input) throws BundleException {
        }

        public void update() throws BundleException {
        }

        public void uninstall() throws BundleException {
        }

        public long getBundleId() {
            return 0L;
        }

        public String getLocation() {
            return null;
        }

        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        public boolean hasPermission(Object permission) {
            return false;
        }

        public URL getResource(String name) {
            return null;
        }

        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        public String getSymbolicName() {
            return null;
        }

        public Enumeration<URL> getResources(String name) throws IOException {
            return null;
        }

        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        public URL getEntry(String path) {
            return null;
        }

        public long getLastModified() {
            return 0L;
        }

        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return null;
        }

        public Version getVersion() {
            return null;
        }

        public int compareTo(Bundle o) {
            return 0;
        }

        public <A> A adapt(Class<A> type) {
            return null;
        }

        public File getDataFile(String filename) {
            return null;
        }
    }
}

