/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients;

import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;

@ThreadSafe
public class SlingClientConfig {
    protected final URI url;
    protected final String user;
    protected final String password;
    protected final CookieStore cookieStore;
    protected final CredentialsProvider credsProvider;
    protected final AuthCache authCache;
    protected final Map<String, String> values;

    protected SlingClientConfig(URI url, String user, String password, CookieStore cookieStore, CredentialsProvider credentialsProvider, AuthCache authCache) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.cookieStore = cookieStore;
        this.credsProvider = credentialsProvider;
        this.authCache = authCache;
        this.values = new ConcurrentHashMap<String, String>();
    }

    public URI getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public CredentialsProvider getCredsProvider() {
        return this.credsProvider;
    }

    public AuthCache getAuthCache() {
        return this.authCache;
    }

    public static class Builder {
        protected URI url;
        protected String user;
        protected String password;
        protected CookieStore cookieStore;
        protected CredentialsProvider credsProvider;
        protected AuthCache authCache;

        protected Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder setUrl(String url) throws URISyntaxException {
            return this.setUrl(new URI(url));
        }

        public Builder setUrl(URI url) {
            this.url = url;
            if (Strings.isNullOrEmpty((String)this.url.getPath()) || !this.url.getPath().endsWith("/")) {
                this.url = this.url.resolve(Strings.nullToEmpty((String)this.url.getPath()) + "/");
            }
            return this;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credsProvider) {
            this.credsProvider = credsProvider;
            return this;
        }

        public Builder setAuthCache(AuthCache authCache) {
            this.authCache = authCache;
            return this;
        }

        public Builder setCookieStore(CookieStore cookieStore) {
            this.cookieStore = cookieStore;
            return this;
        }

        public SlingClientConfig build() {
            if (this.credsProvider == null) {
                this.credsProvider = new BasicCredentialsProvider();
                if (StringUtils.isNotEmpty((CharSequence)this.user)) {
                    HttpHost targetHost = URIUtils.extractHost((URI)this.url);
                    this.credsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials(this.user, this.password));
                }
            }
            if (this.authCache == null) {
                BasicScheme basicScheme = new BasicScheme();
                this.authCache = new BasicAuthCache();
                this.authCache.put(URIUtils.extractHost((URI)this.url), (AuthScheme)basicScheme);
            }
            if (this.cookieStore == null) {
                this.cookieStore = new BasicCookieStore();
            }
            return new SlingClientConfig(this.url, this.user, this.password, this.cookieStore, this.credsProvider, this.authCache);
        }
    }
}

