/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.util.poller.AbstractPoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundlesInstaller {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final OsgiConsoleClient osgiConsoleClient;
    public static final String ACTIVE_STATE = "active";

    public BundlesInstaller(OsgiConsoleClient cc) {
        this.osgiConsoleClient = cc;
    }

    public boolean isInstalled(File bundleFile) throws InterruptedException, IOException {
        String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(bundleFile);
        this.log.debug("Checking if installed: " + bundleSymbolicName);
        boolean installed = this.osgiConsoleClient.checkBundleInstalled(bundleSymbolicName, 1000, 1);
        if (installed) {
            this.log.debug("Already installed: " + bundleSymbolicName);
            return true;
        }
        this.log.debug("Not yet installed: " + bundleSymbolicName);
        return false;
    }

    public boolean isInstalledWithSameVersion(File bundleFile) throws ClientException, IOException {
        String versionInBundle;
        String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(bundleFile);
        String versionOnServer = this.osgiConsoleClient.getBundleVersion(bundleSymbolicName);
        if (versionOnServer.equals(versionInBundle = OsgiConsoleClient.getBundleVersionFromFile(bundleFile))) {
            return true;
        }
        this.log.warn("Installed bundle doesn't match: {}, versionOnServer={}, versionInBundle={}", new Object[]{bundleSymbolicName, versionOnServer, versionInBundle});
        return false;
    }

    public void installBundles(List<File> toInstall, boolean startBundles) throws ClientException, IOException, InterruptedException {
        for (File f : toInstall) {
            String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(f);
            if (this.isInstalled(f)) {
                if (f.getName().contains("SNAPSHOT")) {
                    this.log.info("Reinstalling (due to SNAPSHOT version): {}", (Object)bundleSymbolicName);
                    this.osgiConsoleClient.uninstallBundle(bundleSymbolicName);
                } else if (!this.isInstalledWithSameVersion(f)) {
                    this.log.info("Reinstalling (due to version mismatch): {}", (Object)bundleSymbolicName);
                    this.osgiConsoleClient.uninstallBundle(bundleSymbolicName);
                } else {
                    this.log.info("Not reinstalling: {}", (Object)bundleSymbolicName);
                    continue;
                }
            }
            this.osgiConsoleClient.installBundle(f, startBundles);
            this.log.info("Installed: {}", (Object)bundleSymbolicName);
        }
        this.osgiConsoleClient.refreshPackages();
        this.log.info("{} additional bundles installed", (Object)toInstall.size());
    }

    public void uninstallBundles(List<File> toUninstall) throws ClientException, IOException, InterruptedException {
        for (File f : toUninstall) {
            String bundleSymbolicName = OsgiConsoleClient.getBundleSymbolicName(f);
            if (this.isInstalled(f)) {
                this.log.info("Uninstalling bundle: {}", (Object)bundleSymbolicName);
                this.osgiConsoleClient.uninstallBundle(bundleSymbolicName);
                continue;
            }
            this.log.info("Could not uninstall: {} as it never was installed", (Object)bundleSymbolicName);
        }
        this.osgiConsoleClient.refreshPackages();
        this.log.info("{} additional bundles uninstalled", (Object)toUninstall.size());
    }

    public boolean waitForBundlesInstalled(List<String> symbolicNames, int timeoutSeconds) throws ClientException, InterruptedException {
        this.log.info("Checking that the following bundles are installed (timeout {} seconds): {}", (Object)timeoutSeconds, symbolicNames);
        for (String symbolicName : symbolicNames) {
            boolean started = this.osgiConsoleClient.checkBundleInstalled(symbolicName, 500, 2 * timeoutSeconds);
            if (started) continue;
            return false;
        }
        return true;
    }

    public void startAllBundles(final List<String> symbolicNames, int timeoutSeconds) throws ClientException, InterruptedException {
        this.log.info("Starting bundles (timeout {} seconds): {}", (Object)timeoutSeconds, symbolicNames);
        class StartAllBundlesPoller
        extends AbstractPoller {
            private ClientException exception;

            public StartAllBundlesPoller(List<String> symbolicNames2, long waitInterval, long waitCount) {
                super(waitInterval, waitCount);
            }

            @Override
            public boolean call() {
                for (String bundle : symbolicNames) {
                    try {
                        String state = osgiConsoleClient.getBundleState(bundle);
                        if (state.equalsIgnoreCase(BundlesInstaller.ACTIVE_STATE)) continue;
                        osgiConsoleClient.startBundle(bundle);
                    }
                    catch (ClientException e) {
                        this.exception = e;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean condition() {
                for (String bundle : symbolicNames) {
                    try {
                        String state = osgiConsoleClient.getBundleState(bundle);
                        if (state.equalsIgnoreCase(BundlesInstaller.ACTIVE_STATE)) continue;
                        return false;
                    }
                    catch (ClientException e) {
                        this.exception = e;
                        return false;
                    }
                }
                return true;
            }

            public ClientException getException() {
                return this.exception;
            }
        }
        StartAllBundlesPoller poller = new StartAllBundlesPoller(symbolicNames, 1000L, (long)timeoutSeconds);
        if (!poller.callUntilCondition()) {
            throw new ClientException("Some bundles did not start or timed out", poller.getException());
        }
    }
}

